/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorMessageSendingRecoverer
implements RecoveryCallback<Object> {
    private static final Log logger = LogFactory.getLog(ErrorMessageSendingRecoverer.class);
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();

    public ErrorMessageSendingRecoverer(MessageChannel channel) {
        Assert.notNull((Object)channel, (String)"channel cannot be null");
        this.messagingTemplate.setDefaultChannel(channel);
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    @Override
    public Object recover(RetryContext context) throws Exception {
        Throwable lastThrowable = context.getLastThrowable();
        if (lastThrowable == null) {
            lastThrowable = new RetryExceptionNotAvailableException((Message)context.getAttribute("message"), "No retry exception available; this can occur, for example, if the RetryPolicy allowed zero attempts to execute the handler; RetryContext: " + context.toString());
        }
        if (logger.isDebugEnabled()) {
            String supplement = "";
            if (lastThrowable instanceof MessagingException) {
                supplement = ":failedMessage:" + ((MessagingException)lastThrowable).getFailedMessage();
            }
            logger.debug((Object)("Sending ErrorMessage " + supplement), lastThrowable);
        }
        this.messagingTemplate.send(new ErrorMessage(lastThrowable));
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetryExceptionNotAvailableException
    extends MessagingException {
        private static final long serialVersionUID = 1L;

        public RetryExceptionNotAvailableException(Message<?> message, String description) {
            super(message, description);
        }
    }
}

