/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.Message;
import org.springframework.integration.handler.advice.AbstractRequestHandlerAdvice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHandlerCircuitBreakerAdvice
extends AbstractRequestHandlerAdvice {
    private volatile int threshold = 5;
    private volatile long halfOpenAfter = 1000L;
    private final ConcurrentMap<Object, AdvisedMetadata> metadataMap = new ConcurrentHashMap<Object, AdvisedMetadata>();

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setHalfOpenAfter(long halfOpenAfter) {
        this.halfOpenAfter = halfOpenAfter;
    }

    @Override
    protected Object doInvoke(AbstractRequestHandlerAdvice.ExecutionCallback callback, Object target, Message<?> message) throws Exception {
        AdvisedMetadata metadata = (AdvisedMetadata)this.metadataMap.get(target);
        if (metadata == null) {
            this.metadataMap.putIfAbsent(target, new AdvisedMetadata());
            metadata = (AdvisedMetadata)this.metadataMap.get(target);
        }
        if (metadata.getFailures().get() >= this.threshold && System.currentTimeMillis() - metadata.getLastFailure() < this.halfOpenAfter) {
            throw new CircuitBreakerOpenException("Circuit Breaker is Open for " + target);
        }
        try {
            Object result = callback.execute();
            if (this.logger.isDebugEnabled() && metadata.getFailures().get() > 0) {
                this.logger.debug((Object)("Closing Circuit Breaker for " + target));
            }
            metadata.getFailures().set(0);
            return result;
        }
        catch (Exception e) {
            metadata.getFailures().incrementAndGet();
            metadata.setLastFailure(System.currentTimeMillis());
            throw this.unwrapExceptionIfNecessary(e);
        }
    }

    private class CircuitBreakerOpenException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CircuitBreakerOpenException(String message) {
            super(message);
        }
    }

    private class AdvisedMetadata {
        private final AtomicInteger failures = new AtomicInteger();
        private volatile long lastFailure;

        private AdvisedMetadata() {
        }

        private long getLastFailure() {
            return this.lastFailure;
        }

        private void setLastFailure(long lastFailure) {
            this.lastFailure = lastFailure;
        }

        private AtomicInteger getFailures() {
            return this.failures;
        }
    }
}

