/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.history;

import org.springframework.integration.Message;
import org.springframework.integration.core.MessagePostProcessor;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryWritingMessagePostProcessor
implements MessagePostProcessor {
    private volatile TrackableComponent trackableComponent;
    private volatile boolean shouldTrack;

    public HistoryWritingMessagePostProcessor() {
    }

    public HistoryWritingMessagePostProcessor(TrackableComponent trackableComponent) {
        Assert.notNull((Object)trackableComponent, (String)"trackableComponent must not be null");
        this.trackableComponent = trackableComponent;
    }

    public void setTrackableComponent(TrackableComponent trackableComponent) {
        this.trackableComponent = trackableComponent;
    }

    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    @Override
    public Message<?> postProcessMessage(Message<?> message) {
        if (this.shouldTrack && this.trackableComponent != null) {
            return MessageHistory.write(message, this.trackableComponent);
        }
        return message;
    }
}

