/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.integration.Message;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToJsonTransformer
extends AbstractTransformer {
    public static final String JSON_CONTENT_TYPE = "application/json";
    private final ObjectMapper objectMapper;
    private volatile String contentType = "application/json";
    private volatile boolean contentTypeExplicitlySet = false;

    public ObjectToJsonTransformer(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public ObjectToJsonTransformer() {
        this.objectMapper = new ObjectMapper();
    }

    public void setContentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.contentTypeExplicitlySet = true;
        this.contentType = contentType.trim();
    }

    private String transformPayload(Object payload) throws Exception {
        StringWriter writer = new StringWriter();
        this.objectMapper.writeValue((Writer)writer, payload);
        return writer.toString();
    }

    @Override
    protected Object doTransform(Message<?> message) throws Exception {
        String payload = this.transformPayload(message.getPayload());
        MessageBuilder<String> messageBuilder = MessageBuilder.withPayload(payload);
        LinkedCaseInsensitiveMap headers = new LinkedCaseInsensitiveMap();
        headers.putAll((Map)message.getHeaders());
        if (headers.containsKey((Object)"content-type")) {
            if (this.contentTypeExplicitlySet && StringUtils.hasLength((String)this.contentType)) {
                headers.put("content-type", (Object)this.contentType);
            }
        } else if (StringUtils.hasLength((String)this.contentType)) {
            headers.put("content-type", (Object)this.contentType);
        }
        messageBuilder.copyHeaders((Map<String, ?>)headers);
        return messageBuilder.build();
    }
}

