/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.Collection;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public abstract class AbstractMessageRouter
extends AbstractMessageHandler {
    private volatile MessageChannel defaultOutputChannel;
    private volatile boolean ignoreSendFailures;
    private volatile boolean applySequence;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();

    public void setDefaultOutputChannel(MessageChannel defaultOutputChannel) {
        this.defaultOutputChannel = defaultOutputChannel;
    }

    public void setTimeout(long timeout) {
        this.messagingTemplate.setSendTimeout(timeout);
    }

    public void setIgnoreSendFailures(boolean ignoreSendFailures) {
        this.ignoreSendFailures = ignoreSendFailures;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    @Override
    public String getComponentType() {
        return "router";
    }

    protected MessagingTemplate getMessagingTemplate() {
        return this.messagingTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConversionService getRequiredConversionService() {
        if (this.getConversionService() == null) {
            AbstractMessageRouter abstractMessageRouter = this;
            synchronized (abstractMessageRouter) {
                if (this.getConversionService() == null) {
                    this.setConversionService((ConversionService)ConversionServiceFactory.createDefaultConversionService());
                }
            }
        }
        return this.getConversionService();
    }

    protected abstract Collection<MessageChannel> determineTargetChannels(Message<?> var1);

    @Override
    protected void handleMessageInternal(Message<?> message) {
        boolean sent = false;
        Collection<MessageChannel> results = this.determineTargetChannels(message);
        if (results != null) {
            int sequenceSize = results.size();
            int sequenceNumber = 1;
            for (MessageChannel channel : results) {
                Message<?> messageToSend;
                Message<?> message2 = messageToSend = !this.applySequence ? message : MessageBuilder.fromMessage(message).pushSequenceDetails(message.getHeaders().getId(), sequenceNumber++, sequenceSize).build();
                if (channel == null) continue;
                try {
                    this.messagingTemplate.send(channel, messageToSend);
                    sent = true;
                }
                catch (MessagingException e) {
                    if (!this.ignoreSendFailures) {
                        throw e;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)e);
                }
            }
        }
        if (!sent) {
            if (this.defaultOutputChannel != null) {
                this.messagingTemplate.send(this.defaultOutputChannel, message);
            } else {
                throw new MessageDeliveryException(message, "no channel resolved by router and no default output channel defined");
            }
        }
    }
}

