/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientListRouter
extends AbstractMessageRouter
implements InitializingBean {
    private volatile List<Recipient> recipients;

    public void setChannels(List<MessageChannel> channels) {
        Assert.notEmpty(channels, (String)"channels must not be empty");
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        for (MessageChannel channel : channels) {
            recipients.add(new Recipient(channel));
        }
        this.setRecipients(recipients);
    }

    public void setRecipients(List<Recipient> recipients) {
        Assert.notEmpty(recipients, (String)"recipients must not be empty");
        this.recipients = recipients;
    }

    @Override
    public String getComponentType() {
        return "recipient-list-router";
    }

    @Override
    public final void onInit() {
        Assert.notEmpty(this.recipients, (String)"recipient list must not be empty");
    }

    @Override
    protected Collection<MessageChannel> determineTargetChannels(Message<?> message) {
        ArrayList<MessageChannel> channels = new ArrayList<MessageChannel>();
        List<Recipient> recipientList = this.recipients;
        for (Recipient recipient : recipientList) {
            if (!recipient.accept(message)) continue;
            channels.add(recipient.getChannel());
        }
        return channels;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Recipient {
        private final MessageChannel channel;
        private final MessageSelector selector;

        public Recipient(MessageChannel channel) {
            this(channel, null);
        }

        public Recipient(MessageChannel channel, MessageSelector selector) {
            this.channel = channel;
            this.selector = selector;
        }

        public MessageChannel getChannel() {
            return this.channel;
        }

        public boolean accept(Message<?> message) {
            return this.selector != null ? this.selector.accept(message) : true;
        }
    }
}

