/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splitter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageSplitter
extends AbstractReplyProducingMessageHandler {
    private boolean applySequence = true;

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    @Override
    protected final Object handleRequestMessage(Message<?> message) {
        Object result = this.splitMessage(message);
        if (result == null || result instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)result)) || result.getClass().isArray() && ObjectUtils.isEmpty((Object[])((Object[])result))) {
            return null;
        }
        MessageHeaders headers = message.getHeaders();
        UUID correlationId = headers.getId();
        ArrayList<MessageBuilder> messageBuilders = new ArrayList<MessageBuilder>();
        if (result instanceof Collection) {
            Collection items = (Collection)result;
            int sequenceNumber = 0;
            int sequenceSize = items.size();
            for (Object item : items) {
                messageBuilders.add(this.createBuilder(item, headers, correlationId, ++sequenceNumber, sequenceSize));
            }
        } else if (result.getClass().isArray()) {
            Object[] items = (Object[])result;
            int sequenceNumber = 0;
            int sequenceSize = items.length;
            for (Object item : items) {
                messageBuilders.add(this.createBuilder(item, headers, correlationId, ++sequenceNumber, sequenceSize));
            }
        } else {
            messageBuilders.add(this.createBuilder(result, headers, correlationId, 1, 1));
        }
        return messageBuilders;
    }

    private MessageBuilder createBuilder(Object item, MessageHeaders headers, Object correlationId, int sequenceNumber, int sequenceSize) {
        MessageBuilder<Object> builder;
        if (item instanceof Message) {
            builder = MessageBuilder.fromMessage((Message)item);
        } else {
            builder = MessageBuilder.withPayload(item);
            builder.copyHeaders(headers);
        }
        if (this.applySequence) {
            builder.pushSequenceDetails(correlationId, sequenceNumber, sequenceSize);
        }
        return builder;
    }

    @Override
    public String getComponentType() {
        return "splitter";
    }

    protected abstract Object splitMessage(Message<?> var1);
}

