/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageGroupQueue
extends AbstractQueue<Message<?>>
implements BlockingQueue<Message<?>> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_CAPACITY = Integer.MAX_VALUE;
    private final MessageGroupStore messageGroupStore;
    private final Object groupId;
    private final int capacity;
    private final Lock storeLock;
    private final Condition messageStoreNotFull;
    private final Condition messageStoreNotEmpty;

    public MessageGroupQueue(MessageGroupStore messageGroupStore, Object groupId) {
        this(messageGroupStore, groupId, Integer.MAX_VALUE, new ReentrantLock(true));
    }

    public MessageGroupQueue(MessageGroupStore messageGroupStore, Object groupId, int capacity) {
        this(messageGroupStore, groupId, capacity, new ReentrantLock(true));
    }

    public MessageGroupQueue(MessageGroupStore messageGroupStore, Object groupId, Lock storeLock) {
        this(messageGroupStore, groupId, Integer.MAX_VALUE, storeLock);
    }

    public MessageGroupQueue(MessageGroupStore messageGroupStore, Object groupId, int capacity, Lock storeLock) {
        Assert.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"'capacity' must be greater than 0");
        Assert.notNull((Object)storeLock, (String)"'storeLock' must not be null");
        Assert.notNull((Object)messageGroupStore, (String)"'messageGroupStore' must not be null");
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        this.storeLock = storeLock;
        this.messageStoreNotFull = this.storeLock.newCondition();
        this.messageStoreNotEmpty = this.storeLock.newCondition();
        this.messageGroupStore = messageGroupStore;
        this.groupId = groupId;
        this.capacity = capacity;
    }

    @Override
    public Iterator<Message<?>> iterator() {
        return this.getMessages().iterator();
    }

    @Override
    public int size() {
        return this.messageGroupStore.messageGroupSize(this.groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message<?> peek() {
        Message<?> message = null;
        Lock storeLock = this.storeLock;
        try {
            storeLock.lockInterruptibly();
            try {
                Collection<Message<?>> messages = this.getMessages();
                if (!messages.isEmpty()) {
                    message = messages.iterator().next();
                }
            }
            finally {
                storeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message<?> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Message<?> message = null;
        long timeoutInNanos = unit.toNanos(timeout);
        Lock storeLock = this.storeLock;
        storeLock.lockInterruptibly();
        try {
            while (this.size() == 0 && timeoutInNanos > 0L) {
                timeoutInNanos = this.messageStoreNotEmpty.awaitNanos(timeoutInNanos);
            }
            message = this.doPoll();
        }
        finally {
            storeLock.unlock();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message<?> poll() {
        Message<?> message = null;
        Lock storeLock = this.storeLock;
        try {
            storeLock.lockInterruptibly();
            try {
                message = this.doPoll();
            }
            finally {
                storeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return message;
    }

    @Override
    public int drainTo(Collection<? super Message<?>> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Message<?>> collection, int maxElements) {
        Assert.notNull(collection, (String)"'collection' must not be null");
        int originalSize = collection.size();
        ArrayList list = new ArrayList();
        Lock storeLock = this.storeLock;
        try {
            storeLock.lockInterruptibly();
            try {
                Message<?> message = this.messageGroupStore.pollMessageFromGroup(this.groupId);
                for (int i = 0; i < maxElements && message != null; ++i) {
                    list.add(message);
                    message = this.messageGroupStore.pollMessageFromGroup(this.groupId);
                }
                this.messageStoreNotFull.signal();
            }
            finally {
                storeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            this.logger.warn((Object)"Queue may not have drained completely since this operation was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        collection.addAll(list);
        return collection.size() - originalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Message<?> message) {
        boolean offered = true;
        Lock storeLock = this.storeLock;
        try {
            storeLock.lockInterruptibly();
            try {
                offered = this.doOffer(message);
            }
            finally {
                storeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Message<?> message, long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutInNanos = unit.toNanos(timeout);
        boolean offered = false;
        Lock storeLock = this.storeLock;
        storeLock.lockInterruptibly();
        try {
            if (this.capacity != Integer.MAX_VALUE) {
                while (this.size() == this.capacity && timeoutInNanos > 0L) {
                    timeoutInNanos = this.messageStoreNotFull.awaitNanos(timeoutInNanos);
                }
            }
            if (timeoutInNanos > 0L) {
                offered = this.doOffer(message);
            }
        }
        finally {
            storeLock.unlock();
        }
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Message<?> message) throws InterruptedException {
        Lock storeLock = this.storeLock;
        storeLock.lockInterruptibly();
        try {
            if (this.capacity != Integer.MAX_VALUE) {
                while (this.size() == this.capacity) {
                    this.messageStoreNotFull.await();
                }
            }
            this.doOffer(message);
        }
        finally {
            storeLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        if (this.capacity == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.capacity - this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message<?> take() throws InterruptedException {
        Message<?> message = null;
        Lock storeLock = this.storeLock;
        storeLock.lockInterruptibly();
        try {
            while (this.size() == 0) {
                this.messageStoreNotEmpty.await();
            }
            message = this.doPoll();
        }
        finally {
            storeLock.unlock();
        }
        return message;
    }

    private Collection<Message<?>> getMessages() {
        return this.messageGroupStore.getMessageGroup(this.groupId).getMessages();
    }

    private Message<?> doPoll() {
        Message<?> message = this.messageGroupStore.pollMessageFromGroup(this.groupId);
        this.messageStoreNotFull.signal();
        return message;
    }

    private boolean doOffer(Message<?> message) {
        boolean offered = false;
        if (this.capacity == Integer.MAX_VALUE || this.size() < this.capacity) {
            this.messageGroupStore.addMessageToGroup(this.groupId, message);
            offered = true;
            this.messageStoreNotEmpty.signal();
        }
        return offered;
    }
}

