/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.util.DefaultLockRegistry;
import org.springframework.integration.util.LockRegistry;
import org.springframework.integration.util.UpperBound;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class SimpleMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
MessageGroupStore {
    private volatile LockRegistry lockRegistry;
    private final ConcurrentMap<UUID, Message<?>> idToMessage;
    private final ConcurrentMap<Object, SimpleMessageGroup> groupIdToMessageGroup;
    private final UpperBound individualUpperBound;
    private final UpperBound groupUpperBound;
    private volatile boolean isUsed;

    public SimpleMessageStore(int individualCapacity, int groupCapacity) {
        this(individualCapacity, groupCapacity, new DefaultLockRegistry());
    }

    public SimpleMessageStore(int individualCapacity, int groupCapacity, LockRegistry lockRegistry) {
        Assert.notNull((Object)lockRegistry, (String)"The LockRegistry cannot be null");
        this.idToMessage = new ConcurrentHashMap();
        this.groupIdToMessageGroup = new ConcurrentHashMap<Object, SimpleMessageGroup>();
        this.individualUpperBound = new UpperBound(individualCapacity);
        this.groupUpperBound = new UpperBound(groupCapacity);
        this.lockRegistry = lockRegistry;
    }

    public SimpleMessageStore(int capacity) {
        this(capacity, capacity);
    }

    public SimpleMessageStore() {
        this(0);
    }

    public void setLockRegistry(LockRegistry lockRegistry) {
        Assert.notNull((Object)lockRegistry, (String)"The LockRegistry cannot be null");
        Assert.isTrue((!this.isUsed ? 1 : 0) != 0, (String)"Cannot change the lock registry after the store has been used");
        this.lockRegistry = lockRegistry;
    }

    @Override
    @ManagedAttribute
    public long getMessageCount() {
        return this.idToMessage.size();
    }

    @Override
    public <T> Message<T> addMessage(Message<T> message) {
        this.isUsed = true;
        if (!this.individualUpperBound.tryAcquire(0L)) {
            throw new MessagingException(this.getClass().getSimpleName() + " was out of capacity at, try constructing it with a larger capacity.");
        }
        this.idToMessage.put(message.getHeaders().getId(), message);
        return message;
    }

    @Override
    public Message<?> getMessage(UUID key) {
        return key != null ? (Message)this.idToMessage.get(key) : null;
    }

    @Override
    public Message<?> removeMessage(UUID key) {
        if (key != null) {
            this.individualUpperBound.release();
            return (Message)this.idToMessage.remove(key);
        }
        return null;
    }

    @Override
    public MessageGroup getMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
        if (group == null) {
            return new SimpleMessageGroup(groupId);
        }
        SimpleMessageGroup simpleMessageGroup = new SimpleMessageGroup(group);
        simpleMessageGroup.setLastModified(group.getLastModified());
        return simpleMessageGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        if (!this.groupUpperBound.tryAcquire(0L)) {
            throw new MessagingException(this.getClass().getSimpleName() + " was out of capacity at, try constructing it with a larger capacity.");
        }
        Lock lock = this.lockRegistry.obtain(groupId);
        lock.lockInterruptibly();
        try {
            SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
            if (group == null) {
                group = new SimpleMessageGroup(groupId);
                this.groupIdToMessageGroup.putIfAbsent(groupId, group);
            }
            group.add(message);
            ((SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId)).setLastModified(System.currentTimeMillis());
            SimpleMessageGroup simpleMessageGroup = group;
            lock.unlock();
            return simpleMessageGroup;
        }
        catch (Throwable throwable) {
            try {
                lock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MessagingException("Interrupted while obtaining lock", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageGroup(Object groupId) {
        Lock lock = this.lockRegistry.obtain(groupId);
        try {
            lock.lockInterruptibly();
            try {
                if (!this.groupIdToMessageGroup.containsKey(groupId)) {
                    return;
                }
                this.groupUpperBound.release(((SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId)).size());
                this.groupIdToMessageGroup.remove(groupId);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessagingException("Interrupted while obtaining lock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Lock lock = this.lockRegistry.obtain(groupId);
        lock.lockInterruptibly();
        try {
            SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
            Assert.notNull((Object)group, (String)("MessageGroup for groupId '" + groupId + "' " + "can not be located while attempting to remove Message from the MessageGroup"));
            group.remove(messageToRemove);
            group.setLastModified(System.currentTimeMillis());
            SimpleMessageGroup simpleMessageGroup = group;
            lock.unlock();
            return simpleMessageGroup;
        }
        catch (Throwable throwable) {
            try {
                lock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MessagingException("Interrupted while obtaining lock", (Throwable)e);
            }
        }
    }

    @Override
    public Iterator<MessageGroup> iterator() {
        return new HashSet(this.groupIdToMessageGroup.values()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Lock lock = this.lockRegistry.obtain(groupId);
        try {
            lock.lockInterruptibly();
            try {
                SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
                Assert.notNull((Object)group, (String)("MessageGroup for groupId '" + groupId + "' " + "can not be located while attempting to set 'lastReleasedSequenceNumber'"));
                group.setLastReleasedMessageSequenceNumber(sequenceNumber);
                group.setLastModified(System.currentTimeMillis());
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessagingException("Interrupted while obtaining lock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeGroup(Object groupId) {
        Lock lock = this.lockRegistry.obtain(groupId);
        try {
            lock.lockInterruptibly();
            try {
                SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
                Assert.notNull((Object)group, (String)("MessageGroup for groupId '" + groupId + "' " + "can not be located while attempting to complete the MessageGroup"));
                group.complete();
                group.setLastModified(System.currentTimeMillis());
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessagingException("Interrupted while obtaining lock", (Throwable)e);
        }
    }

    @Override
    public Message<?> pollMessageFromGroup(Object groupId) {
        Collection<Message<?>> messageList = this.getMessageGroup(groupId).getMessages();
        Message<?> message = null;
        if (!CollectionUtils.isEmpty(messageList) && (message = messageList.iterator().next()) != null) {
            this.removeMessageFromGroup(groupId, message);
        }
        return message;
    }

    @Override
    public int messageGroupSize(Object groupId) {
        return this.getMessageGroup(groupId).size();
    }
}

