/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transaction;

import java.util.Map;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.TransactionSynchronizationProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluatingTransactionSynchronizationProcessor
extends IntegrationObjectSupport
implements TransactionSynchronizationProcessor {
    private volatile StandardEvaluationContext evaluationContext;
    private volatile Expression beforeCommitExpression;
    private volatile Expression afterCommitExpression;
    private volatile Expression afterRollbackExpression;
    private volatile MessageChannel beforeCommitChannel;
    private volatile MessageChannel afterCommitChannel;
    private volatile MessageChannel afterRollbackChannel;

    public void setBeforeCommitChannel(MessageChannel beforeCommitChannel) {
        Assert.notNull((Object)beforeCommitChannel, (String)"'beforeCommitChannel' must not be null");
        this.beforeCommitChannel = beforeCommitChannel;
    }

    public void setAfterCommitChannel(MessageChannel afterCommitChannel) {
        Assert.notNull((Object)afterCommitChannel, (String)"'afterCommitChannel' must not be null");
        this.afterCommitChannel = afterCommitChannel;
    }

    public void setAfterRollbackChannel(MessageChannel afterRollbackChannel) {
        Assert.notNull((Object)afterRollbackChannel, (String)"'afterRollbackChannel' must not be null");
        this.afterRollbackChannel = afterRollbackChannel;
    }

    public void setBeforeCommitExpression(Expression beforeCommitExpression) {
        Assert.notNull((Object)beforeCommitExpression, (String)"'beforeCommitExpression' must not be null");
        this.beforeCommitExpression = beforeCommitExpression;
    }

    public void setAfterCommitExpression(Expression afterCommitExpression) {
        Assert.notNull((Object)afterCommitExpression, (String)"'afterCommitExpression' must not be null");
        this.afterCommitExpression = afterCommitExpression;
    }

    public void setAfterRollbackExpression(Expression afterRollbackExpression) {
        Assert.notNull((Object)afterRollbackExpression, (String)"'afterRollbackExpression' must not be null");
        this.afterRollbackExpression = afterRollbackExpression;
    }

    @Override
    public void processBeforeCommit(IntegrationResourceHolder holder) {
        this.doProcess(holder, this.beforeCommitExpression, this.beforeCommitChannel, "beforeCommit");
    }

    @Override
    public void processAfterCommit(IntegrationResourceHolder holder) {
        this.doProcess(holder, this.afterCommitExpression, this.afterCommitChannel, "afterCommit");
    }

    @Override
    public void processAfterRollback(IntegrationResourceHolder holder) {
        this.doProcess(holder, this.afterRollbackExpression, this.afterRollbackChannel, "afterRollback");
    }

    private void doProcess(IntegrationResourceHolder holder, Expression expression, MessageChannel messageChannel, String expressionType) {
        Message<?> message = holder.getMessage();
        if (message != null) {
            if (expression != null) {
                StandardEvaluationContext evaluationContextToUse;
                Object value;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Evaluating " + expressionType + " expression: '" + expression.getExpressionString() + "' on " + message));
                }
                if ((value = expression.getValue((EvaluationContext)(evaluationContextToUse = this.prepareEvaluationContextToUse(holder)), message)) != null) {
                    Message<Object> spelResultMessage = null;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Sending expression result message to " + messageChannel + " " + "as part of '" + expressionType + "' transaction synchronization"));
                    }
                    try {
                        spelResultMessage = MessageBuilder.withPayload(value).copyHeaders(message.getHeaders()).build();
                        this.sendMessage(messageChannel, spelResultMessage);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Failed to send " + expressionType + " evaluation result " + spelResultMessage), (Throwable)e);
                    }
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Expression evaluation returned null");
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending received message to " + messageChannel + " as part of '" + expressionType + "' transaction synchronization"));
                }
                try {
                    if (messageChannel != null) {
                        this.sendMessage(messageChannel, MessageBuilder.fromMessage(message).build());
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to send " + message), (Throwable)e);
                }
            }
        }
    }

    private void sendMessage(MessageChannel channel, Message<?> message) {
        channel.send(message, 0L);
    }

    private StandardEvaluationContext prepareEvaluationContextToUse(Object resource) {
        StandardEvaluationContext evaluationContextToUse;
        if (resource != null) {
            evaluationContextToUse = this.createEvaluationContext();
            if (resource instanceof IntegrationResourceHolder) {
                IntegrationResourceHolder holder = (IntegrationResourceHolder)resource;
                for (Map.Entry<String, Object> entry : holder.getAttributes().entrySet()) {
                    String key = entry.getKey();
                    evaluationContextToUse.setVariable(key, entry.getValue());
                }
            }
        } else {
            if (this.evaluationContext == null) {
                this.evaluationContext = this.createEvaluationContext();
            }
            evaluationContextToUse = this.evaluationContext;
        }
        return evaluationContextToUse;
    }

    protected StandardEvaluationContext createEvaluationContext() {
        if (this.getBeanFactory() != null) {
            return ExpressionUtils.createStandardEvaluationContext((BeanResolver)new BeanFactoryResolver(this.getBeanFactory()), this.getConversionService());
        }
        return ExpressionUtils.createStandardEvaluationContext(this.getConversionService());
    }
}

