/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.integration.Message;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformer
extends IntegrationObjectSupport
implements Transformer {
    @Override
    public final Message<?> transform(Message<?> message) {
        try {
            Object result = this.doTransform(message);
            if (result == null) {
                return null;
            }
            return result instanceof Message ? (Message<Object>)result : MessageBuilder.withPayload(result).copyHeaders(message.getHeaders()).build();
        }
        catch (MessageTransformationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageTransformationException(message, "failed to transform message", e);
        }
    }

    protected abstract Object doTransform(Message<?> var1) throws Exception;
}

