/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.UUID;
import org.springframework.integration.Message;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimCheckInTransformer
extends AbstractTransformer {
    private final MessageStore messageStore;

    public ClaimCheckInTransformer(MessageStore messageStore) {
        Assert.notNull((Object)messageStore, (String)"MessageStore must not be null");
        this.messageStore = messageStore;
    }

    @Override
    protected Object doTransform(Message<?> message) throws Exception {
        Assert.notNull(message, (String)"message must not be null");
        Object payload = message.getPayload();
        Assert.notNull(payload, (String)"payload must not be null");
        Message<?> storedMessage = this.messageStore.addMessage(message);
        MessageBuilder<UUID> responseBuilder = MessageBuilder.withPayload(storedMessage.getHeaders().getId());
        responseBuilder.copyHeaders(message.getHeaders());
        return responseBuilder.build();
    }
}

