/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.MethodInvokingMessageProcessor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderEnricher
implements Transformer,
BeanNameAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(HeaderEnricher.class);
    private final Map<String, ? extends HeaderValueMessageProcessor<?>> headersToAdd;
    private volatile MessageProcessor<?> messageProcessor;
    private volatile boolean defaultOverwrite = false;
    private volatile boolean shouldSkipNulls = true;
    private Object beanName;

    public HeaderEnricher() {
        this(null);
    }

    public HeaderEnricher(Map<String, ? extends HeaderValueMessageProcessor<?>> headersToAdd) {
        this.headersToAdd = headersToAdd != null ? headersToAdd : new HashMap();
    }

    public <T> void setMessageProcessor(MessageProcessor<T> messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void setDefaultOverwrite(boolean defaultOverwrite) {
        this.defaultOverwrite = defaultOverwrite;
    }

    public void setShouldSkipNulls(boolean shouldSkipNulls) {
        this.shouldSkipNulls = shouldSkipNulls;
    }

    @Override
    public Message<?> transform(Message<?> message) {
        try {
            HashMap<String, Object> headerMap = new HashMap<String, Object>(message.getHeaders());
            this.addHeadersFromMessageProcessor(message, headerMap);
            for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headersToAdd.entrySet()) {
                Object value;
                boolean headerDoesNotExist;
                String key = entry.getKey();
                HeaderValueMessageProcessor<?> valueProcessor = entry.getValue();
                Boolean shouldOverwrite = valueProcessor.isOverwrite();
                if (shouldOverwrite == null) {
                    shouldOverwrite = this.defaultOverwrite;
                }
                boolean bl = headerDoesNotExist = headerMap.get(key) == null;
                if (!headerDoesNotExist && !shouldOverwrite.booleanValue() || (value = valueProcessor.processMessage(message)) == null && this.shouldSkipNulls) continue;
                headerMap.put(key, value);
            }
            return MessageBuilder.withPayload(message.getPayload()).copyHeaders(headerMap).build();
        }
        catch (Exception e) {
            throw new MessagingException(message, "failed to transform message headers", e);
        }
    }

    private void addHeadersFromMessageProcessor(Message<?> message, Map<String, Object> headerMap) {
        if (this.messageProcessor != null) {
            Object result = this.messageProcessor.processMessage(message);
            if (result instanceof Map) {
                Map resultMap = (Map)result;
                for (Object key : resultMap.keySet()) {
                    if (key instanceof String) {
                        if (!this.defaultOverwrite && headerMap.get(key) != null) continue;
                        headerMap.put((String)key, resultMap.get(key));
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("ignoring value for non-String key: " + key));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("expected a Map result from processor, but received: " + result));
            }
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        boolean shouldOverwrite = this.defaultOverwrite;
        for (HeaderValueMessageProcessor<?> processor : this.headersToAdd.values()) {
            Boolean processerOverwrite = processor.isOverwrite();
            if (processerOverwrite == null) continue;
            shouldOverwrite |= processerOverwrite.booleanValue();
        }
        if (!shouldOverwrite && !this.shouldSkipNulls) {
            logger.warn((Object)(this.beanName + " is configured to not overwrite existing headers. 'shouldSkipNulls = false' will have no effect"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageProcessingHeaderValueMessageProcessor
    extends AbstractHeaderValueMessageProcessor<Object> {
        private final MessageProcessor<?> targetProcessor;

        public <T> MessageProcessingHeaderValueMessageProcessor(MessageProcessor<T> targetProcessor) {
            this.targetProcessor = targetProcessor;
        }

        public MessageProcessingHeaderValueMessageProcessor(Object targetObject) {
            this(targetObject, null);
        }

        public MessageProcessingHeaderValueMessageProcessor(Object targetObject, String method) {
            this.targetProcessor = new MethodInvokingMessageProcessor(targetObject, method);
        }

        @Override
        public Object processMessage(Message<?> message) {
            return this.targetProcessor.processMessage(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExpressionEvaluatingHeaderValueMessageProcessor<T>
    extends AbstractHeaderValueMessageProcessor<T>
    implements BeanFactoryAware {
        private static final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
        private final ExpressionEvaluatingMessageProcessor<T> targetProcessor;

        public ExpressionEvaluatingHeaderValueMessageProcessor(Expression expression, Class<T> expectedType) {
            this.targetProcessor = new ExpressionEvaluatingMessageProcessor<T>(expression, expectedType);
        }

        public ExpressionEvaluatingHeaderValueMessageProcessor(String expressionString, Class<T> expectedType) {
            Expression expression = expressionParser.parseExpression(expressionString);
            this.targetProcessor = new ExpressionEvaluatingMessageProcessor<T>(expression, expectedType);
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.targetProcessor.setBeanFactory(beanFactory);
        }

        @Override
        public T processMessage(Message<?> message) {
            return this.targetProcessor.processMessage(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StaticHeaderValueMessageProcessor<T>
    extends AbstractHeaderValueMessageProcessor<T> {
        private final T value;

        public StaticHeaderValueMessageProcessor(T value) {
            this.value = value;
        }

        @Override
        public T processMessage(Message<?> message) {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractHeaderValueMessageProcessor<T>
    implements HeaderValueMessageProcessor<T> {
        private volatile Boolean overwrite = null;

        AbstractHeaderValueMessageProcessor() {
        }

        public void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        @Override
        public Boolean isOverwrite() {
            return this.overwrite;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HeaderValueMessageProcessor<T>
    extends MessageProcessor<T> {
        public Boolean isOverwrite();
    }
}

