/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyslogToMapTransformer
extends AbstractPayloadTransformer<Object, Map<String, ?>> {
    public static final String FACILITY = "FACILITY";
    public static final String SEVERITY = "SEVERITY";
    public static final String TIMESAMP = "TIMESTAMP";
    public static final String HOST = "HOST";
    public static final String TAG = "TAG";
    public static final String MESSAGE = "MESSAGE";
    public static final String UNDECODED = "UNDECODED";
    private final Pattern pattern = Pattern.compile("<([^>]+)>(.{15}) ([^ ]+) ([^:]+): (.*)", 32);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");

    private Map<String, ?> transform(byte[] payloadBytes) {
        String payload;
        try {
            payload = new String(payloadBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            payload = new String(payloadBytes);
        }
        return this.transform(payload);
    }

    private Map<String, ?> transform(String payload) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Matcher matcher = this.pattern.matcher(payload);
        if (matcher.matches()) {
            try {
                String facilityString = matcher.group(1);
                int facility = Integer.parseInt(facilityString);
                int severity = facility & 7;
                map.put(FACILITY, facility >>= 3);
                map.put(SEVERITY, severity);
                String timestamp = matcher.group(2);
                try {
                    Date date = this.dateFormat.parse(timestamp);
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    int month = calendar.get(2);
                    calendar.setTime(date);
                    if (month == 11 && calendar.get(2) == 0) {
                        calendar.set(1, year + 1);
                    } else if (month == 0 && calendar.get(2) == 1) {
                        calendar.set(1, year - 1);
                    } else {
                        calendar.set(1, year);
                    }
                    map.put(TIMESAMP, calendar.getTime());
                }
                catch (Exception e) {
                    map.put(TIMESAMP, timestamp);
                }
                map.put(HOST, matcher.group(3));
                map.put(TAG, matcher.group(4));
                map.put(MESSAGE, matcher.group(5));
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Could not decode:" + payload), (Throwable)e);
                }
                map.clear();
                map.put(UNDECODED, payload);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not decode:" + payload));
            }
            map.put(UNDECODED, payload);
        }
        return map;
    }

    @Override
    protected Map<String, ?> transformPayload(Object payload) throws Exception {
        Assert.isTrue((payload instanceof byte[] || payload instanceof String ? 1 : 0) != 0, (String)"payload must be String or byte[]");
        if (payload instanceof byte[]) {
            return this.transform((byte[])payload);
        }
        if (payload instanceof String) {
            return this.transform((String)payload);
        }
        return null;
    }
}

