/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.concurrent.Executor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class ErrorHandlingTaskExecutor
implements TaskExecutor {
    private final Executor executor;
    private final ErrorHandler errorHandler;

    public ErrorHandlingTaskExecutor(Executor executor, ErrorHandler errorHandler) {
        Assert.notNull((Object)executor, (String)"executor must not be null");
        Assert.notNull((Object)errorHandler, (String)"errorHandler must not be null");
        this.executor = executor;
        this.errorHandler = errorHandler;
    }

    public void execute(final Runnable task) {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    ErrorHandlingTaskExecutor.this.errorHandler.handleError(t);
                }
            }
        });
    }
}

