/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.javaconfig;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.camel.main.MainSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class Main
extends org.apache.camel.spring.Main {
    private String basedPackages;
    private String configClasses;
    private Class[] configClass;

    public Main() {
        this.addOption((MainSupport.Option)new MainSupport.ParameterOption("bp", "basedPackages", "Sets the based packages of Spring java config ApplicationContext", "basedPackages"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setBasedPackages(parameter);
            }
        });
        this.addOption((MainSupport.Option)new MainSupport.ParameterOption("cc", "configClasses", "Sets the config of Spring java config ApplicationContext", "configureClasses"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setConfigClasses(parameter);
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        instance = main;
        main.run(args);
    }

    public void setBasedPackages(String config) {
        this.basedPackages = config;
    }

    public String getBasedPackages() {
        return this.basedPackages;
    }

    public void setConfigClasses(String config) {
        this.configClasses = config;
    }

    public String getConfigClasses() {
        return this.configClasses;
    }

    @Deprecated
    public void setConfigClassesString(String config) {
        this.setConfigClasses(config);
    }

    @Deprecated
    public String getConfigClassesString() {
        return this.getConfigClasses();
    }

    public Class[] getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(Class ... configClass) {
        this.configClass = configClass;
    }

    private Class<?>[] getConfigClasses(String configureClasses) {
        String[] classes;
        ArrayList<Class> answer = new ArrayList<Class>();
        for (String className : classes = configureClasses.split("(;|,)")) {
            Class configClass = ObjectHelper.loadClass((String)(className = className.trim()));
            if (configClass == null) continue;
            answer.add(configClass);
        }
        return answer.toArray(new Class[answer.size()]);
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        AbstractApplicationContext parentContext = this.getParentApplicationContext();
        AnnotationConfigApplicationContext acApplicationContext = new AnnotationConfigApplicationContext();
        if (parentContext != null) {
            acApplicationContext.setParent((ApplicationContext)parentContext);
        }
        if (this.getConfigClasses() != null) {
            Class<?>[] configClasses = this.getConfigClasses(this.getConfigClasses());
            for (Class<?> clazz : configClasses) {
                acApplicationContext.register(new Class[]{clazz});
            }
        }
        if (this.getConfigClass() != null) {
            for (Class cls : this.getConfigClass()) {
                acApplicationContext.register(new Class[]{cls});
            }
        }
        if (this.getBasedPackages() != null) {
            String[] basePackages = this.getBasedPackages().split("(;|,)");
            for (String string : basePackages) {
                String string2 = string.trim();
                acApplicationContext.scan(new String[]{string2});
            }
        }
        acApplicationContext.refresh();
        return acApplicationContext;
    }
}

