/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jdbc.JdbcPrepareStatementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJdbcPrepareStatementStrategy
implements JdbcPrepareStatementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJdbcPrepareStatementStrategy.class);

    @Override
    public String prepareQuery(String query2, boolean allowNamedParameters) throws SQLException {
        String answer = allowNamedParameters && this.hasNamedParameters(query2) ? query2.replaceAll("\\:\\?\\w+", "\\?") : query2;
        LOG.trace("Prepared query: {}", (Object)answer);
        return answer;
    }

    @Override
    public Iterator<?> createPopulateIterator(final String query2, String preparedQuery, int expectedParams, final Exchange exchange, Object value) throws SQLException {
        Map map = null;
        if (exchange.getIn().hasHeaders()) {
            map = exchange.getIn().getHeader("CamelJdbcParameters") != null ? exchange.getIn().getHeader("CamelJdbcParameters", Map.class) : exchange.getIn().getHeaders();
        }
        final Map headerMap = map;
        if (this.hasNamedParameters(query2)) {
            try {
                return new Iterator<Object>(){
                    private NamedQueryParser parser;
                    private Object next;
                    private boolean done;
                    private boolean preFetched;
                    {
                        this.parser = new NamedQueryParser(query2);
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.done && !this.preFetched) {
                            this.next();
                            this.preFetched = true;
                        }
                        return !this.done;
                    }

                    @Override
                    public Object next() {
                        if (!this.preFetched) {
                            boolean contains;
                            String key = this.parser.next();
                            if (key == null) {
                                this.done = true;
                                return null;
                            }
                            boolean bl = contains = headerMap != null && headerMap.containsKey(key);
                            if (!contains) {
                                throw new RuntimeExchangeException("Cannot find key [" + key + "] in message body or headers to use when setting named parameter in query [" + query2 + "]", exchange);
                            }
                            this.next = headerMap.get(key);
                        }
                        this.preFetched = false;
                        return this.next;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            catch (Exception e) {
                throw new SQLException("Error iterating parameters for the query: " + query2, e);
            }
        }
        return exchange.getContext().getTypeConverter().convertTo(Iterator.class, headerMap != null ? headerMap.values() : null);
    }

    @Override
    public void populateStatement(PreparedStatement ps, Iterator<?> iterator, int expectedParams) throws SQLException {
        int argNumber;
        if (expectedParams > 0) {
            for (argNumber = 1; iterator != null && iterator.hasNext() && argNumber <= expectedParams; ++argNumber) {
                Object value = iterator.next();
                LOG.trace("Setting parameter #{} with value: {}", (Object)argNumber, value);
                ps.setObject(argNumber, value);
            }
        }
        if (argNumber - 1 != expectedParams) {
            throw new SQLException("Number of parameters mismatch. Expected: " + expectedParams + ", was:" + (argNumber - 1));
        }
    }

    protected boolean hasNamedParameters(String query2) {
        NamedQueryParser parser = new NamedQueryParser(query2);
        return parser.next() != null;
    }

    private static final class NamedQueryParser {
        private static final Pattern PATTERN = Pattern.compile("\\:\\?(\\w+)");
        private final Matcher matcher;

        private NamedQueryParser(String query2) {
            this.matcher = PATTERN.matcher(query2);
        }

        public String next() {
            if (!this.matcher.find()) {
                return null;
            }
            return this.matcher.group(1);
        }
    }
}

