/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.language.simple.types.SimpleTokenType;
import org.apache.camel.language.simple.types.TokenType;
import org.apache.camel.util.ObjectHelper;

public final class SimpleTokenizer {
    private static final int NUMBER_OF_TOKENS = 47;
    private static final SimpleTokenType[] KNOWN_TOKENS = new SimpleTokenType[47];
    private static final String[] FUNCTION_START = new String[]{"${", "$simple{"};

    private SimpleTokenizer() {
    }

    public static boolean hasFunctionStartToken(String expression) {
        if (expression != null) {
            return expression.contains(FUNCTION_START[0]) || expression.contains(FUNCTION_START[1]);
        }
        return false;
    }

    public static SimpleToken nextToken(String expression, int index, boolean allowEscape, TokenType ... filter) {
        return SimpleTokenizer.doNextToken(expression, index, allowEscape, filter);
    }

    public static SimpleToken nextToken(String expression, int index, boolean allowEscape) {
        return SimpleTokenizer.doNextToken(expression, index, allowEscape, new TokenType[0]);
    }

    private static SimpleToken doNextToken(String expression, int index, boolean allowEscape, TokenType ... filters) {
        boolean escapeAllowed;
        char ch;
        boolean numericAllowed = SimpleTokenizer.acceptType(TokenType.numericValue, filters);
        if (numericAllowed) {
            StringBuilder sb = new StringBuilder();
            boolean digit = true;
            while (digit && index < expression.length()) {
                digit = Character.isDigit(expression.charAt(index));
                if (digit) {
                    ch = expression.charAt(index);
                    sb.append(ch);
                    ++index;
                    continue;
                }
                boolean decimalSeparator = '.' == expression.charAt(index) || ',' == expression.charAt(index);
                if (!decimalSeparator || sb.length() <= 0) continue;
                char ch2 = expression.charAt(index);
                sb.append(ch2);
                ++index;
                digit = true;
            }
            if (sb.length() > 0) {
                return new SimpleToken(new SimpleTokenType(TokenType.numericValue, sb.toString()), index);
            }
        }
        boolean bl = escapeAllowed = allowEscape && SimpleTokenizer.acceptType(TokenType.escape, filters);
        if (escapeAllowed) {
            boolean escaped;
            StringBuilder sb = new StringBuilder();
            ch = expression.charAt(index);
            boolean bl2 = escaped = '\\' == ch;
            if (escaped && index < expression.length() - 1) {
                char next = expression.charAt(++index);
                boolean special = false;
                if ('n' == next) {
                    sb.append("\n");
                    special = true;
                } else if ('t' == next) {
                    sb.append("\t");
                    special = true;
                } else if ('r' == next) {
                    sb.append("\r");
                    special = true;
                } else if ('}' == next) {
                    sb.append("}");
                    special = true;
                } else {
                    sb.append(ch);
                }
                return new SimpleToken(new SimpleTokenType(TokenType.character, sb.toString()), index, special ? 2 : 1);
            }
        }
        String text = expression.substring(index);
        for (int i = 0; i < 47; ++i) {
            SimpleTokenType token = KNOWN_TOKENS[i];
            if (!SimpleTokenizer.acceptType(token.getType(), filters) || !SimpleTokenizer.acceptToken(token, text, expression, index)) continue;
            return new SimpleToken(token, index);
        }
        ch = expression.charAt(index);
        SimpleToken token = new SimpleToken(new SimpleTokenType(TokenType.character, "" + ch), index);
        return token;
    }

    private static boolean acceptType(TokenType type, TokenType ... filters) {
        if (filters == null || filters.length == 0) {
            return true;
        }
        for (TokenType filter : filters) {
            if (type != filter) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptToken(SimpleTokenType token, String text, String expression, int index) {
        if (token.isUnary() && text.startsWith(token.getValue())) {
            String after;
            int endLen = 1;
            int len = token.getValue().length();
            String previous = "";
            if (index - endLen >= 0) {
                previous = expression.substring(index - endLen, index);
            }
            boolean whiteSpace = ObjectHelper.isEmpty(after = text.substring(len)) || after.startsWith(" ");
            boolean functionEnd = previous.equals("}");
            return functionEnd && whiteSpace;
        }
        return text.startsWith(token.getValue());
    }

    static {
        SimpleTokenizer.KNOWN_TOKENS[0] = new SimpleTokenType(TokenType.functionStart, "${");
        SimpleTokenizer.KNOWN_TOKENS[1] = new SimpleTokenType(TokenType.functionStart, "$simple{");
        SimpleTokenizer.KNOWN_TOKENS[2] = new SimpleTokenType(TokenType.functionEnd, "}");
        SimpleTokenizer.KNOWN_TOKENS[3] = new SimpleTokenType(TokenType.whiteSpace, " ");
        SimpleTokenizer.KNOWN_TOKENS[4] = new SimpleTokenType(TokenType.whiteSpace, "\t");
        SimpleTokenizer.KNOWN_TOKENS[5] = new SimpleTokenType(TokenType.whiteSpace, "\n");
        SimpleTokenizer.KNOWN_TOKENS[6] = new SimpleTokenType(TokenType.whiteSpace, "\r");
        SimpleTokenizer.KNOWN_TOKENS[7] = new SimpleTokenType(TokenType.singleQuote, "'");
        SimpleTokenizer.KNOWN_TOKENS[8] = new SimpleTokenType(TokenType.doubleQuote, "\"");
        SimpleTokenizer.KNOWN_TOKENS[9] = new SimpleTokenType(TokenType.booleanValue, "true");
        SimpleTokenizer.KNOWN_TOKENS[10] = new SimpleTokenType(TokenType.booleanValue, "false");
        SimpleTokenizer.KNOWN_TOKENS[11] = new SimpleTokenType(TokenType.nullValue, "null");
        SimpleTokenizer.KNOWN_TOKENS[12] = new SimpleTokenType(TokenType.escape, "\\");
        SimpleTokenizer.KNOWN_TOKENS[13] = new SimpleTokenType(TokenType.binaryOperator, "==");
        SimpleTokenizer.KNOWN_TOKENS[14] = new SimpleTokenType(TokenType.binaryOperator, "=~");
        SimpleTokenizer.KNOWN_TOKENS[15] = new SimpleTokenType(TokenType.binaryOperator, ">=");
        SimpleTokenizer.KNOWN_TOKENS[16] = new SimpleTokenType(TokenType.binaryOperator, "<=");
        SimpleTokenizer.KNOWN_TOKENS[17] = new SimpleTokenType(TokenType.binaryOperator, ">");
        SimpleTokenizer.KNOWN_TOKENS[18] = new SimpleTokenType(TokenType.binaryOperator, "<");
        SimpleTokenizer.KNOWN_TOKENS[19] = new SimpleTokenType(TokenType.binaryOperator, "!=~");
        SimpleTokenizer.KNOWN_TOKENS[20] = new SimpleTokenType(TokenType.binaryOperator, "!=");
        SimpleTokenizer.KNOWN_TOKENS[21] = new SimpleTokenType(TokenType.binaryOperator, "not is");
        SimpleTokenizer.KNOWN_TOKENS[22] = new SimpleTokenType(TokenType.binaryOperator, "!is");
        SimpleTokenizer.KNOWN_TOKENS[23] = new SimpleTokenType(TokenType.binaryOperator, "is");
        SimpleTokenizer.KNOWN_TOKENS[24] = new SimpleTokenType(TokenType.binaryOperator, "not contains");
        SimpleTokenizer.KNOWN_TOKENS[25] = new SimpleTokenType(TokenType.binaryOperator, "!contains");
        SimpleTokenizer.KNOWN_TOKENS[26] = new SimpleTokenType(TokenType.binaryOperator, "contains");
        SimpleTokenizer.KNOWN_TOKENS[27] = new SimpleTokenType(TokenType.binaryOperator, "!~~");
        SimpleTokenizer.KNOWN_TOKENS[28] = new SimpleTokenType(TokenType.binaryOperator, "~~");
        SimpleTokenizer.KNOWN_TOKENS[29] = new SimpleTokenType(TokenType.binaryOperator, "not regex");
        SimpleTokenizer.KNOWN_TOKENS[30] = new SimpleTokenType(TokenType.binaryOperator, "!regex");
        SimpleTokenizer.KNOWN_TOKENS[31] = new SimpleTokenType(TokenType.binaryOperator, "regex");
        SimpleTokenizer.KNOWN_TOKENS[32] = new SimpleTokenType(TokenType.binaryOperator, "not in");
        SimpleTokenizer.KNOWN_TOKENS[33] = new SimpleTokenType(TokenType.binaryOperator, "!in");
        SimpleTokenizer.KNOWN_TOKENS[34] = new SimpleTokenType(TokenType.binaryOperator, "in");
        SimpleTokenizer.KNOWN_TOKENS[35] = new SimpleTokenType(TokenType.binaryOperator, "not range");
        SimpleTokenizer.KNOWN_TOKENS[36] = new SimpleTokenType(TokenType.binaryOperator, "!range");
        SimpleTokenizer.KNOWN_TOKENS[37] = new SimpleTokenType(TokenType.binaryOperator, "range");
        SimpleTokenizer.KNOWN_TOKENS[38] = new SimpleTokenType(TokenType.binaryOperator, "startsWith");
        SimpleTokenizer.KNOWN_TOKENS[39] = new SimpleTokenType(TokenType.binaryOperator, "starts with");
        SimpleTokenizer.KNOWN_TOKENS[40] = new SimpleTokenType(TokenType.binaryOperator, "endsWith");
        SimpleTokenizer.KNOWN_TOKENS[41] = new SimpleTokenType(TokenType.binaryOperator, "ends with");
        SimpleTokenizer.KNOWN_TOKENS[42] = new SimpleTokenType(TokenType.unaryOperator, "++");
        SimpleTokenizer.KNOWN_TOKENS[43] = new SimpleTokenType(TokenType.unaryOperator, "--");
        SimpleTokenizer.KNOWN_TOKENS[44] = new SimpleTokenType(TokenType.logicalOperator, "&&");
        SimpleTokenizer.KNOWN_TOKENS[45] = new SimpleTokenType(TokenType.logicalOperator, "||");
        SimpleTokenizer.KNOWN_TOKENS[46] = new SimpleTokenType(TokenType.minusValue, "-");
    }
}

