/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.ObjectHelper;

@Language(value="tokenize")
public class TokenizeLanguage
extends LanguageSupport
implements PropertyConfigurer {
    private String token;
    private String endToken;
    private String inheritNamespaceTagName;
    private String headerName;
    private boolean regex;
    private boolean xml;
    private boolean includeTokens;
    private String group;
    private String groupDelimiter;
    private boolean skipFirst;

    @Deprecated
    public static Expression tokenize(String token) {
        return TokenizeLanguage.tokenize(token, false);
    }

    @Deprecated
    public static Expression tokenize(String token, boolean regex) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(token);
        language.setRegex(regex);
        return language.createExpression(null);
    }

    @Deprecated
    public static Expression tokenize(String headerName, String token) {
        return TokenizeLanguage.tokenize(headerName, token, false);
    }

    @Deprecated
    public static Expression tokenize(String headerName, String token, boolean regex) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setHeaderName(headerName);
        language.setToken(token);
        language.setRegex(regex);
        return language.createExpression(null);
    }

    @Deprecated
    public static Expression tokenizePair(String startToken, String endToken, boolean includeTokens) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(startToken);
        language.setEndToken(endToken);
        language.setIncludeTokens(includeTokens);
        return language.createExpression(null);
    }

    @Deprecated
    public static Expression tokenizeXML(String tagName, String inheritNamespaceTagName) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(tagName);
        language.setInheritNamespaceTagName(inheritNamespaceTagName);
        language.setXml(true);
        return language.createExpression(null);
    }

    @Override
    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "token": {
                this.setToken(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "endtoken": 
            case "endToken": {
                this.setEndToken(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "inheritnamespacetagname": 
            case "inheritNamespaceTagName": {
                this.setInheritNamespaceTagName(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "headername": 
            case "headerName": {
                this.setHeaderName(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "regex": {
                this.setRegex(PropertyConfigurerSupport.property(camelContext, Boolean.class, value));
                return true;
            }
            case "xml": {
                this.setXml(PropertyConfigurerSupport.property(camelContext, Boolean.class, value));
                return true;
            }
            case "includetokens": 
            case "includeTokens": {
                this.setIncludeTokens(PropertyConfigurerSupport.property(camelContext, Boolean.class, value));
                return true;
            }
            case "group": {
                this.setGroup(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "groupdelimiter": 
            case "groupDelimiter": {
                this.setGroupDelimiter(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "skipfirst": 
            case "skipFirst": {
                this.setSkipFirst(PropertyConfigurerSupport.property(camelContext, Boolean.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression));
    }

    public Expression createExpression() {
        ObjectHelper.notNull(this.token, "token");
        if (this.endToken != null && this.inheritNamespaceTagName != null) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        if (this.isXml() && (this.endToken != null || this.includeTokens)) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        Expression answer = null;
        if (this.isXml()) {
            answer = ExpressionBuilder.tokenizeXMLExpression(this.token, this.inheritNamespaceTagName);
        } else if (this.endToken != null) {
            answer = ExpressionBuilder.tokenizePairExpression(this.token, this.endToken, this.includeTokens);
        }
        if (answer == null) {
            Expression exp = this.headerName == null ? ExpressionBuilder.bodyExpression() : ExpressionBuilder.headerExpression(this.headerName);
            answer = this.regex ? ExpressionBuilder.regexTokenizeExpression(exp, this.token) : ExpressionBuilder.tokenizeExpression(exp, this.token);
            if (this.group == null && this.skipFirst) {
                answer = ExpressionBuilder.skipFirstExpression(answer);
            }
        }
        if (this.group != null) {
            if (this.isXml()) {
                answer = ExpressionBuilder.groupXmlIteratorExpression(answer, this.group);
            } else {
                String delim = this.groupDelimiter != null ? this.groupDelimiter : this.token;
                answer = ExpressionBuilder.groupIteratorExpression(answer, delim, this.group, this.skipFirst);
            }
        }
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        if (ObjectHelper.isNotEmpty(expression)) {
            this.token = expression;
        }
        return this.createExpression();
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression, properties));
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        TokenizeLanguage answer = new TokenizeLanguage();
        answer.setToken(this.property(String.class, properties, 0, this.token));
        answer.setEndToken(this.property(String.class, properties, 1, this.endToken));
        answer.setInheritNamespaceTagName(this.property(String.class, properties, 2, this.inheritNamespaceTagName));
        answer.setHeaderName(this.property(String.class, properties, 3, this.headerName));
        answer.setGroupDelimiter(this.property(String.class, properties, 4, this.groupDelimiter));
        answer.setRegex(this.property(Boolean.TYPE, properties, 5, this.regex));
        answer.setXml(this.property(Boolean.TYPE, properties, 6, this.xml));
        answer.setIncludeTokens(this.property(Boolean.TYPE, properties, 7, this.includeTokens));
        answer.setGroup(this.property(String.class, properties, 8, this.group));
        answer.setSkipFirst(this.property(Boolean.TYPE, properties, 9, this.skipFirst));
        return answer.createExpression(expression);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public String getInheritNamespaceTagName() {
        return this.inheritNamespaceTagName;
    }

    public void setInheritNamespaceTagName(String inheritNamespaceTagName) {
        this.inheritNamespaceTagName = inheritNamespaceTagName;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public boolean isIncludeTokens() {
        return this.includeTokens;
    }

    public void setIncludeTokens(boolean includeTokens) {
        this.includeTokens = includeTokens;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = "0".equals(group) ? null : group;
    }

    public String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }

    public boolean isSkipFirst() {
        return this.skipFirst;
    }

    public void setSkipFirst(boolean skipFirst) {
        this.skipFirst = skipFirst;
    }
}

