/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.TypeConverters;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.engine.PooledExchangeFactory;
import org.apache.camel.impl.engine.PooledProcessorExchangeFactory;
import org.apache.camel.impl.engine.PrototypeExchangeFactory;
import org.apache.camel.impl.engine.PrototypeProcessorExchangeFactory;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.ClassicUuidGenerator;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.OffUuidGenerator;
import org.apache.camel.support.ShortUuidGenerator;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.support.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConfigurationConfigurer {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurationConfigurer.class);

    private DefaultConfigurationConfigurer() {
    }

    public static void configure(CamelContext camelContext, DefaultConfigurationProperties<?> config) throws Exception {
        ExtendedCamelContext ecc = camelContext.adapt(ExtendedCamelContext.class);
        if (config.getStartupRecorder() != null) {
            if ("false".equals(config.getStartupRecorder())) {
                ecc.getStartupStepRecorder().setEnabled(false);
            } else if ("logging".equals(config.getStartupRecorder())) {
                if (!(ecc.getStartupStepRecorder() instanceof LoggingStartupStepRecorder)) {
                    ecc.setStartupStepRecorder(new LoggingStartupStepRecorder());
                }
            } else if ("java-flight-recorder".equals(config.getStartupRecorder()) && !ecc.getStartupStepRecorder().getClass().getName().startsWith("org.apache.camel.startup.jfr")) {
                throw new IllegalArgumentException("Cannot find Camel Java Flight Recorder on classpath. Add camel-jfr to classpath.");
            }
        }
        ecc.getStartupStepRecorder().setMaxDepth(config.getStartupRecorderMaxDepth());
        ecc.getStartupStepRecorder().setRecording(config.isStartupRecorderRecording());
        ecc.getStartupStepRecorder().setStartupRecorderDuration(config.getStartupRecorderDuration());
        ecc.getStartupStepRecorder().setRecordingDir(config.getStartupRecorderDir());
        ecc.getStartupStepRecorder().setRecordingProfile(config.getStartupRecorderProfile());
        ecc.setLightweight(config.isLightweight());
        ecc.getBeanPostProcessor().setEnabled(config.isBeanPostProcessorEnabled());
        ecc.getBeanIntrospection().setExtendedStatistics(config.isBeanIntrospectionExtendedStatistics());
        if (config.getBeanIntrospectionLoggingLevel() != null) {
            ecc.getBeanIntrospection().setLoggingLevel(config.getBeanIntrospectionLoggingLevel());
        }
        ecc.getBeanIntrospection().afterPropertiesConfigured(camelContext);
        if ("pooled".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory(new PooledExchangeFactory());
            ecc.setProcessorExchangeFactory(new PooledProcessorExchangeFactory());
        } else if ("prototype".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory(new PrototypeExchangeFactory());
            ecc.setProcessorExchangeFactory(new PrototypeProcessorExchangeFactory());
        }
        ecc.getExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getProcessorExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        ecc.getProcessorExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            ecc.setName(config.getName());
        }
        if (config.getStartupSummaryLevel() != null) {
            camelContext.setStartupSummaryLevel(config.getStartupSummaryLevel());
        }
        if (config.getShutdownTimeout() > 0) {
            camelContext.getShutdownStrategy().setTimeout(config.getShutdownTimeout());
        }
        camelContext.getShutdownStrategy().setSuppressLoggingOnTimeout(config.isShutdownSuppressLoggingOnTimeout());
        camelContext.getShutdownStrategy().setShutdownNowOnTimeout(config.isShutdownNowOnTimeout());
        camelContext.getShutdownStrategy().setShutdownRoutesInReverseOrder(config.isShutdownRoutesInReverseOrder());
        camelContext.getShutdownStrategy().setLogInflightExchangesOnTimeout(config.isShutdownLogInflightExchangesOnTimeout());
        camelContext.getInflightRepository().setInflightBrowseEnabled(config.isInflightRepositoryBrowseEnabled());
        if (config.getLogDebugMaxChars() != 0) {
            camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "" + config.getLogDebugMaxChars());
        }
        camelContext.setStreamCaching(config.isStreamCachingEnabled());
        camelContext.getStreamCachingStrategy().setAnySpoolRules(config.isStreamCachingAnySpoolRules());
        camelContext.getStreamCachingStrategy().setBufferSize(config.getStreamCachingBufferSize());
        camelContext.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(config.isStreamCachingRemoveSpoolDirectoryWhenStopping());
        camelContext.getStreamCachingStrategy().setSpoolCipher(config.getStreamCachingSpoolCipher());
        if (config.getStreamCachingSpoolDirectory() != null) {
            camelContext.getStreamCachingStrategy().setSpoolDirectory(config.getStreamCachingSpoolDirectory());
        }
        if (config.getStreamCachingSpoolThreshold() != 0L) {
            camelContext.getStreamCachingStrategy().setSpoolThreshold(config.getStreamCachingSpoolThreshold());
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryLimit() != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;
            if ("Committed".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
            } else if ("Max".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            } else {
                throw new IllegalArgumentException("Invalid option " + config.getStreamCachingSpoolUsedHeapMemoryLimit() + " must either be Committed or Max");
            }
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(limit);
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryThreshold() != 0) {
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(config.getStreamCachingSpoolUsedHeapMemoryThreshold());
        }
        if ("default".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new DefaultUuidGenerator());
        } else if ("short".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new ShortUuidGenerator());
        } else if ("classic".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new ClassicUuidGenerator());
        } else if ("simple".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new SimpleUuidGenerator());
        } else if ("off".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new OffUuidGenerator());
            LOG.warn("Using OffUuidGenerator (Only intended for development purposes)");
        }
        camelContext.setMessageHistory(config.isMessageHistory());
        camelContext.setLogMask(config.isLogMask());
        camelContext.setLogExhaustedMessageBody(config.isLogExhaustedMessageBody());
        camelContext.setAutoStartup(config.isAutoStartup());
        camelContext.setAllowUseOriginalMessage(config.isAllowUseOriginalMessage());
        camelContext.setCaseInsensitiveHeaders(config.isCaseInsensitiveHeaders());
        camelContext.setAutowiredEnabled(config.isAutowiredEnabled());
        camelContext.setUseBreadcrumb(config.isUseBreadcrumb());
        camelContext.setUseDataType(config.isUseDataType());
        camelContext.setDumpRoutes(config.isDumpRoutes());
        camelContext.setUseMDCLogging(config.isUseMdcLogging());
        camelContext.setMDCLoggingKeysPattern(config.getMdcLoggingKeysPattern());
        camelContext.setLoadTypeConverters(config.isLoadTypeConverters());
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(config.isEndpointRuntimeStatisticsEnabled());
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
        }
        if (config.getGlobalOptions() != null) {
            Map<String, String> map = camelContext.getGlobalOptions();
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.putAll(config.getGlobalOptions());
            camelContext.setGlobalOptions(map);
        }
        camelContext.getGlobalEndpointConfiguration().setAutowiredEnabled(config.isAutowiredEnabled());
        camelContext.getGlobalEndpointConfiguration().setBridgeErrorHandler(config.isEndpointBridgeErrorHandler());
        camelContext.getGlobalEndpointConfiguration().setLazyStartProducer(config.isEndpointLazyStartProducer());
        camelContext.setBacklogTracing(config.isBacklogTracing());
        camelContext.setTracing(config.isTracing());
        camelContext.setTracingPattern(config.getTracingPattern());
        if (config.getThreadNamePattern() != null) {
            camelContext.getExecutorServiceManager().setThreadNamePattern(config.getThreadNamePattern());
        }
        if (config.getRouteFilterIncludePattern() != null || config.getRouteFilterExcludePattern() != null) {
            camelContext.getExtension(Model.class).setRouteFilterPattern(config.getRouteFilterIncludePattern(), config.getRouteFilterExcludePattern());
        }
        if (config.isRouteControllerSuperviseEnabled()) {
            SupervisingRouteController src = camelContext.getRouteController().supervising();
            if (config.getRouteControllerIncludeRoutes() != null) {
                src.setIncludeRoutes(config.getRouteControllerIncludeRoutes());
            }
            if (config.getRouteControllerExcludeRoutes() != null) {
                src.setExcludeRoutes(config.getRouteControllerExcludeRoutes());
            }
            if (config.getRouteControllerThreadPoolSize() > 0) {
                src.setThreadPoolSize(config.getRouteControllerThreadPoolSize());
            }
            if (config.getRouteControllerBackOffDelay() > 0L) {
                src.setBackOffDelay(config.getRouteControllerBackOffDelay());
            }
            if (config.getRouteControllerInitialDelay() > 0L) {
                src.setInitialDelay(config.getRouteControllerInitialDelay());
            }
            if (config.getRouteControllerBackOffMaxAttempts() > 0L) {
                src.setBackOffMaxAttempts(config.getRouteControllerBackOffMaxAttempts());
            }
            if (config.getRouteControllerBackOffMaxDelay() > 0L) {
                src.setBackOffMaxDelay(config.getRouteControllerBackOffDelay());
            }
            if (config.getRouteControllerBackOffMaxElapsedTime() > 0L) {
                src.setBackOffMaxElapsedTime(config.getRouteControllerBackOffMaxElapsedTime());
            }
            if (config.getRouteControllerBackOffMultiplier() > 0.0) {
                src.setBackOffMultiplier(config.getRouteControllerBackOffMultiplier());
            }
            src.setUnhealthyOnExhausted(config.isRouteControllerUnhealthyOnExhausted());
        }
        if (config.getRouteControllerLoggingLevel() != null) {
            camelContext.getRouteController().setLoggingLevel(config.getRouteControllerLoggingLevel());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void afterConfigure(CamelContext camelContext) throws Exception {
        Set<HealthCheckRepository> repositories;
        void var40_47;
        HealthCheckRegistry healthCheckRegistry;
        GlobalSSLContextParametersSupplier globalSSLContextParametersSupplier;
        Map<String, ServiceRegistry> serviceRegistries;
        Set<RoutePolicyFactory> rpfs;
        Set<CamelClusterService> csss;
        Set<EndpointStrategy> ess;
        Set<TypeConverters> tcs;
        ExchangeFactory exf;
        ShutdownStrategy ss;
        ReactiveExecutor re;
        MessageHistoryFactory mhf;
        NodeIdFactory nif;
        Debugger debugger;
        ProcessorFactory pf;
        ThreadPoolFactory tpf;
        ExecutorServiceManager esm;
        UuidGenerator ug;
        RouteController rc;
        FactoryFinderResolver ffr;
        ClassResolver cr;
        ModelJAXBContextFactory mjcf;
        RuntimeEndpointRegistry rer;
        UnitOfWorkFactory uowf;
        EventFactory ef;
        ManagementObjectNameStrategy mons;
        ManagementStrategy ms;
        AsyncProcessorAwaitManager apam;
        InflightRepository ir;
        BacklogTracer bt;
        PropertiesComponent pc;
        Registry registry = camelContext.getRegistry();
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        ExtendedCamelContext ecc = camelContext.adapt(ExtendedCamelContext.class);
        StartupStepRecorder ssr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, StartupStepRecorder.class);
        if (ssr != null) {
            ecc.setStartupStepRecorder(ssr);
        }
        if ((pc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, PropertiesComponent.class)) != null) {
            ecc.setPropertiesComponent(pc);
        }
        if ((bt = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, BacklogTracer.class)) != null) {
            ecc.setExtension(BacklogTracer.class, bt);
        }
        if ((ir = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, InflightRepository.class)) != null) {
            ecc.setInflightRepository(ir);
        }
        if ((apam = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AsyncProcessorAwaitManager.class)) != null) {
            ecc.setAsyncProcessorAwaitManager(apam);
        }
        if ((ms = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementStrategy.class)) != null) {
            ecc.setManagementStrategy(ms);
        }
        if ((mons = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementObjectNameStrategy.class)) != null) {
            managementStrategy.setManagementObjectNameStrategy(mons);
        }
        if ((ef = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, EventFactory.class)) != null) {
            managementStrategy.setEventFactory(ef);
        }
        if ((uowf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UnitOfWorkFactory.class)) != null) {
            ecc.setUnitOfWorkFactory(uowf);
        }
        if ((rer = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RuntimeEndpointRegistry.class)) != null) {
            ecc.setRuntimeEndpointRegistry(rer);
        }
        if ((mjcf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ModelJAXBContextFactory.class)) != null) {
            ecc.setModelJAXBContextFactory(mjcf);
        }
        if ((cr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ClassResolver.class)) != null) {
            ecc.setClassResolver(cr);
        }
        if ((ffr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, FactoryFinderResolver.class)) != null) {
            ecc.setFactoryFinderResolver(ffr);
        }
        if ((rc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RouteController.class)) != null) {
            ecc.setRouteController(rc);
        }
        if ((ug = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UuidGenerator.class)) != null) {
            ecc.setUuidGenerator(ug);
        }
        if ((esm = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExecutorServiceManager.class)) != null) {
            ecc.setExecutorServiceManager(esm);
        }
        if ((tpf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ThreadPoolFactory.class)) != null) {
            ecc.getExecutorServiceManager().setThreadPoolFactory(tpf);
        }
        if ((pf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ProcessorFactory.class)) != null) {
            ecc.setProcessorFactory(pf);
        }
        if ((debugger = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, Debugger.class)) != null) {
            ecc.setDebugger(debugger);
        }
        if ((nif = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, NodeIdFactory.class)) != null) {
            ecc.setNodeIdFactory(nif);
        }
        if ((mhf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, MessageHistoryFactory.class)) != null) {
            ecc.setMessageHistoryFactory(mhf);
        }
        if ((re = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ReactiveExecutor.class)) != null) {
            ecc.setReactiveExecutor(re);
        }
        if ((ss = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ShutdownStrategy.class)) != null) {
            ecc.setShutdownStrategy(ss);
        }
        if ((exf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExchangeFactory.class)) != null) {
            ecc.setExchangeFactory(exf);
        }
        if (!(tcs = registry.findByType(TypeConverters.class)).isEmpty()) {
            tcs.forEach(t -> camelContext.getTypeConverterRegistry().addTypeConverters((TypeConverters)t));
        }
        if (!(ess = registry.findByType(EndpointStrategy.class)).isEmpty()) {
            ess.forEach(ecc::registerEndpointCallback);
        }
        if (!(csss = registry.findByType(CamelClusterService.class)).isEmpty()) {
            for (CamelClusterService css : csss) {
                camelContext.addService(css);
            }
        }
        if (!(rpfs = registry.findByType(RoutePolicyFactory.class)).isEmpty()) {
            rpfs.forEach(camelContext::addRoutePolicyFactory);
        }
        Predicate<EventNotifier> containsEventNotifier = managementStrategy.getEventNotifiers()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, EventNotifier.class, containsEventNotifier.negate(), managementStrategy::addEventNotifier);
        Predicate<InterceptStrategy> containsInterceptStrategy = camelContext.adapt(ExtendedCamelContext.class).getInterceptStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, InterceptStrategy.class, containsInterceptStrategy.negate(), camelContext.adapt(ExtendedCamelContext.class)::addInterceptStrategy);
        Predicate<LifecycleStrategy> containsLifecycleStrategy = camelContext.getLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, LifecycleStrategy.class, containsLifecycleStrategy.negate(), camelContext::addLifecycleStrategy);
        ModelCamelContext mcc = camelContext.adapt(ModelCamelContext.class);
        Predicate<ModelLifecycleStrategy> containsModelLifecycleStrategy = mcc.getModelLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, ModelLifecycleStrategy.class, containsModelLifecycleStrategy.negate(), mcc::addModelLifecycleStrategy);
        Map<String, LogListener> logListeners = registry.findByTypeWithName(LogListener.class);
        if (logListeners != null && !logListeners.isEmpty()) {
            for (LogListener logListener : logListeners.values()) {
                boolean bl = ecc.getLogListeners() != null && ecc.getLogListeners().contains(logListener);
                if (bl) continue;
                ecc.addLogListener(logListener);
            }
        }
        if ((serviceRegistries = registry.findByTypeWithName(ServiceRegistry.class)) != null && !serviceRegistries.isEmpty()) {
            for (Map.Entry<String, ServiceRegistry> entry : serviceRegistries.entrySet()) {
                ServiceRegistry service = entry.getValue();
                if (service.getId() == null) {
                    service.setGeneratedId(camelContext.getUuidGenerator().generateUuid());
                }
                LOG.info("Using ServiceRegistry with id: {} and implementation: {}", (Object)service.getId(), (Object)service);
                camelContext.addService(service);
            }
        }
        if ((globalSSLContextParametersSupplier = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, GlobalSSLContextParametersSupplier.class)) != null) {
            camelContext.setSSLContextParameters((SSLContextParameters)globalSSLContextParametersSupplier.get());
        }
        if ((healthCheckRegistry = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext(camelContext);
            LOG.debug("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            camelContext.setExtension(HealthCheckRegistry.class, healthCheckRegistry);
        } else {
            HealthCheckRegistry healthCheckRegistry2 = HealthCheckRegistry.get(camelContext);
            if (healthCheckRegistry2 != null) {
                healthCheckRegistry2.setCamelContext(camelContext);
            }
        }
        if (var40_47 != null && ObjectHelper.isNotEmpty(repositories = registry.findByType(HealthCheckRepository.class))) {
            for (HealthCheckRepository repository : repositories) {
                var40_47.register(repository);
            }
        }
        DefaultConfigurationConfigurer.initThreadPoolProfiles(registry, camelContext);
    }

    public static void afterPropertiesSet(CamelContext camelContext) throws Exception {
    }

    private static <T> T getSingleBeanOfType(Registry registry, Class<T> type) {
        Map<String, T> beans = registry.findByTypeWithName(type);
        if (beans.size() == 1) {
            return beans.values().iterator().next();
        }
        return null;
    }

    private static <T> void registerPropertiesForBeanTypesWithCondition(Registry registry, Class<T> beanType, Predicate<T> condition, Consumer<T> propertySetter) {
        Map<String, T> beans = registry.findByTypeWithName(beanType);
        if (!ObjectHelper.isNotEmpty(beans)) {
            return;
        }
        String simpleName = beanType.getSimpleName();
        beans.forEach((name, bean) -> {
            if (condition.test(bean)) {
                LOG.info("Adding custom {} with id: {} and implementation: {}", new Object[]{simpleName, name, bean});
                propertySetter.accept(bean);
            }
        });
    }

    private static void initThreadPoolProfiles(Registry registry, CamelContext camelContext) {
        HashSet<String> defaultIds = new HashSet<String>();
        Map<String, ThreadPoolProfile> profiles = registry.findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry<String, ThreadPoolProfile> entry : profiles.entrySet()) {
                ThreadPoolProfile profile = entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", (Object)entry.getKey(), (Object)profile);
                    camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }
}

