/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.FileNotFoundException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoutesCollector
implements RoutesCollector {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Collection<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
        AntPathMatcher matcher = new AntPathMatcher();
        Set<LambdaRouteBuilder> lrbs = camelContext.getRegistry().findByType(LambdaRouteBuilder.class);
        for (final LambdaRouteBuilder lrb : lrbs) {
            RouteBuilder rb = new RouteBuilder(){

                @Override
                public void configure() throws Exception {
                    lrb.accept(this);
                }
            };
            routes.add(rb);
        }
        Set<RoutesBuilder> builders = camelContext.getRegistry().findByType(RoutesBuilder.class);
        for (RoutesBuilder routesBuilder : builders) {
            String[] parts;
            boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
            if (abs) continue;
            String name = routesBuilder.getClass().getName();
            name = name.replace('.', '/');
            boolean match = !"false".equals(includePattern);
            String exclude = camelContext.adapt(ExtendedCamelContext.class).getTestExcludeRoutes();
            if (match && ObjectHelper.isNotEmpty(exclude)) {
                exclude = exclude.replace('.', '/');
                for (String part : parts = exclude.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty(excludePattern)) {
                for (String part : parts = excludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty(includePattern)) {
                for (String part : parts = includePattern.split(",")) {
                    match = matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                    if (match) break;
                }
            }
            this.log.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
            if (!match) continue;
            routes.add(routesBuilder);
        }
        return routes;
    }

    @Override
    public Collection<RoutesBuilder> collectRoutesFromDirectory(CamelContext camelContext, String excludePattern, String includePattern) {
        String[] excludes;
        ExtendedCamelContext ecc = camelContext.adapt(ExtendedCamelContext.class);
        PackageScanResourceResolver resolver = ecc.getPackageScanResourceResolver();
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>();
        String[] includes = includePattern != null ? includePattern.split(",") : null;
        String[] stringArray = excludes = excludePattern != null ? excludePattern.split(",") : null;
        if (includes == null) {
            this.log.debug("Include patter is empty, no routes will be discovered from resources");
            return answer;
        }
        StopWatch watch = new StopWatch();
        if (ObjectHelper.equal("false", includePattern)) {
            return answer;
        }
        for (String include : includes) {
            this.log.debug("Loading additional RoutesBuilder from: {}", (Object)include);
            try {
                for (Resource resource : resolver.findResources(include)) {
                    Collection<RoutesBuilder> builders;
                    if (!"false".equals(excludePattern) && AntPathMatcher.INSTANCE.anyMatch(excludes, resource.getLocation()) || (builders = ecc.getRoutesLoader().findRoutesBuilders(resource)).isEmpty()) continue;
                    this.log.debug("Found {} route builder from location: {}", (Object)builders.size(), (Object)include);
                    answer.addAll(builders);
                }
            }
            catch (FileNotFoundException e) {
                this.log.debug("No RoutesBuilder found in {}. Skipping detection.", (Object)include);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
            if (!answer.isEmpty()) {
                this.log.debug("Loaded {} ({} millis) additional RoutesBuilder from: {}, pattern: {}", new Object[]{answer.size(), watch.taken(), include, includePattern});
                continue;
            }
            this.log.debug("No additional RoutesBuilder discovered from: {}", (Object)includePattern);
        }
        return answer;
    }
}

