/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.main.PropertyOptionKey;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MainHelper.class);
    private final Set<String> componentEnvNames = new HashSet<String>();
    private final Set<String> dataformatEnvNames = new HashSet<String>();
    private final Set<String> languageEnvNames = new HashSet<String>();

    public MainHelper() {
        try {
            InputStream is = MainHelper.class.getResourceAsStream("/org/apache/camel/main/components.properties");
            MainHelper.loadLines(is, this.componentEnvNames, s -> "CAMEL_COMPONENT_" + s.toUpperCase(Locale.US).replace('-', '_'));
            IOHelper.close((Closeable)is);
            is = MainHelper.class.getResourceAsStream("/org/apache/camel/main/dataformats.properties");
            MainHelper.loadLines(is, this.dataformatEnvNames, s -> "CAMEL_DATAFORMAT_" + s.toUpperCase(Locale.US).replace('-', '_'));
            IOHelper.close((Closeable)is);
            is = MainHelper.class.getResourceAsStream("/org/apache/camel/main/languages.properties");
            MainHelper.loadLines(is, this.languageEnvNames, s -> "CAMEL_LANGUAGE_" + s.toUpperCase(Locale.US).replace('-', '_'));
            IOHelper.close((Closeable)is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading catalog information from classpath", e);
        }
    }

    public void bootstrapDone() {
        this.componentEnvNames.clear();
        this.dataformatEnvNames.clear();
        this.languageEnvNames.clear();
    }

    public static String toEnvVar(String name) {
        return name.toUpperCase(Locale.US).replaceAll("[^\\w]", "-").replace('-', '_');
    }

    public static Optional<String> lookupPropertyFromSysOrEnv(String name) {
        String answer = System.getProperty(name);
        if (answer == null) {
            answer = System.getenv(MainHelper.toEnvVar(name));
        }
        return Optional.ofNullable(answer);
    }

    public static Properties loadEnvironmentVariablesAsProperties(String[] prefixes) {
        OrderedProperties answer = new OrderedProperties();
        if (prefixes == null || prefixes.length == 0) {
            return answer;
        }
        for (String prefix : prefixes) {
            String pk = prefix.toUpperCase(Locale.US).replaceAll("[^\\w]", "-");
            String pk2 = pk.replace('-', '_');
            System.getenv().forEach((k, v) -> {
                if ((k = k.toUpperCase(Locale.US)).startsWith(pk) || k.startsWith(pk2)) {
                    String key = k.toLowerCase(Locale.US).replace('_', '.');
                    answer.put(key, v);
                }
            });
        }
        return answer;
    }

    public static Map<String, String> filterEnvVariables(String[] prefixes) {
        HashMap<String, String> answer = new HashMap<String, String>();
        System.getenv().forEach((k, v) -> {
            String uk = k.toUpperCase(Locale.US);
            for (String prefix : prefixes) {
                if (!uk.startsWith(prefix)) continue;
                answer.put(uk, (String)v);
            }
        });
        return answer;
    }

    public void addComponentEnvVariables(Map<String, String> env, Properties properties, boolean custom) {
        HashSet toRemove = new HashSet();
        env.forEach((k, v) -> {
            if (custom) {
                toRemove.add(k);
                String ck = "camel.component." + k.substring(16).toLowerCase(Locale.US).replace('_', '-');
                ck = ck.replaceFirst("-", ".");
                properties.put(ck, v);
            } else {
                Optional<String> e = this.componentEnvNames.stream().filter(k::startsWith).findFirst();
                if (e.isPresent()) {
                    toRemove.add(k);
                    String cname = "camel.component." + e.get().substring(16).toLowerCase(Locale.US).replace('_', '-');
                    String option = k.substring(cname.length() + 1).toLowerCase(Locale.US).replace('_', '-');
                    properties.put(cname + "." + option, v);
                }
            }
        });
        toRemove.forEach(env::remove);
    }

    public void addDataFormatEnvVariables(Map<String, String> env, Properties properties, boolean custom) {
        HashSet toRemove = new HashSet();
        env.forEach((k, v) -> {
            if (custom) {
                toRemove.add(k);
                String ck = "camel.dataformat." + k.substring(17).toLowerCase(Locale.US).replace('_', '-');
                ck = ck.replaceFirst("-", ".");
                properties.put(ck, v);
            } else {
                Optional<String> e = this.dataformatEnvNames.stream().filter(k::startsWith).findFirst();
                if (e.isPresent()) {
                    toRemove.add(k);
                    String cname = "camel.dataformat." + e.get().substring(17).toLowerCase(Locale.US).replace('_', '-');
                    String option = k.substring(cname.length() + 1).toLowerCase(Locale.US).replace('_', '-');
                    properties.put(cname + "." + option, v);
                }
            }
        });
        toRemove.forEach(env::remove);
    }

    public void addLanguageEnvVariables(Map<String, String> env, Properties properties, boolean custom) {
        HashSet toRemove = new HashSet();
        env.forEach((k, v) -> {
            if (custom) {
                toRemove.add(k);
                String ck = "camel.language." + k.substring(15).toLowerCase(Locale.US).replace('_', '-');
                ck = ck.replaceFirst("-", ".");
                properties.put(ck, v);
            } else {
                Optional<String> e = this.languageEnvNames.stream().filter(k::startsWith).findFirst();
                if (e.isPresent()) {
                    toRemove.add(k);
                    String cname = "camel.language." + e.get().substring(15).toLowerCase(Locale.US).replace('_', '-');
                    String option = k.substring(cname.length() + 1).toLowerCase(Locale.US).replace('_', '-');
                    properties.put(cname + "." + option, v);
                }
            }
        });
        toRemove.forEach(env::remove);
    }

    public static Properties loadJvmSystemPropertiesAsProperties(String[] prefixes) {
        OrderedProperties answer = new OrderedProperties();
        if (prefixes == null || prefixes.length == 0) {
            return answer;
        }
        for (String prefix : prefixes) {
            String pk = prefix.toUpperCase(Locale.US).replaceAll("[^\\w]", "-");
            String pk2 = pk.replace('-', '.');
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = k.toString().toUpperCase(Locale.US);
                if (key.startsWith(pk) || key.startsWith(pk2)) {
                    answer.put(k.toString(), v);
                }
            }));
        }
        return answer;
    }

    public static String optionKey(String key) {
        key = StringHelper.dashToCamelCase(key);
        return key;
    }

    public static boolean setPropertiesOnTarget(CamelContext context, Object target, Object source) throws Exception {
        ObjectHelper.notNull(context, "context");
        ObjectHelper.notNull(target, "target");
        boolean rc = false;
        PropertyConfigurer targetConfigurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService(target);
            targetConfigurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (targetConfigurer == null) {
            String name = target.getClass().getName();
            targetConfigurer = context.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        PropertyConfigurer sourceConfigurer = null;
        if (source instanceof Component) {
            ServiceHelper.initService(source);
            sourceConfigurer = ((Component)source).getComponentPropertyConfigurer();
        }
        if (sourceConfigurer == null) {
            String name = source.getClass().getName();
            sourceConfigurer = context.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        if (targetConfigurer != null && sourceConfigurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)((Object)sourceConfigurer);
            for (String key : getter.getAllOptions(source).keySet()) {
                Object value = getter.getOptionValue(source, key, true);
                if (value == null) continue;
                rc |= targetConfigurer.configure(context, target, key, value, true);
            }
        }
        return rc;
    }

    public static boolean setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties, String optionPrefix, boolean failIfNotSet, boolean ignoreCase, Map<String, String> autoConfiguredProperties) {
        ObjectHelper.notNull(context, "context");
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        boolean rc = false;
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService(target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            String name = target.getClass().getName();
            configurer = context.adapt(ExtendedCamelContext.class).getBootstrapConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        try {
            LinkedHashMap<String, Object> backup = new LinkedHashMap<String, Object>(properties);
            rc = PropertyBindingSupport.build().withMandatory(failIfNotSet).withRemoveParameters(true).withConfigurer(configurer).withIgnoreCase(ignoreCase).bind(context, target, properties);
            for (Map.Entry entry : backup.entrySet()) {
                if (entry.getValue() == null || properties.containsKey(entry.getKey())) continue;
                String prefix = optionPrefix;
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                LOG.debug("Configured property: {}{}={} on bean: {}", new Object[]{prefix, entry.getKey(), entry.getValue(), target});
                autoConfiguredProperties.put(prefix + (String)entry.getKey(), entry.getValue().toString());
            }
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                String prefix = e.getOptionPrefix();
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                String string = key = prefix != null ? prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            if (failIfNotSet) {
                throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), optionPrefix, key, e.getCause());
            }
            LOG.debug("Error configuring property (" + key + ") with name: " + e.getPropertyName() + ") on bean: " + target + " with value: " + e.getValue() + ". This exception is ignored as failIfNotSet=false.", (Throwable)e);
        }
        return rc;
    }

    public static void computeProperties(String keyPrefix, String key, Properties prop, Map<PropertyOptionKey, Map<String, Object>> properties, Function<String, Iterable<Object>> supplier) {
        if (key.startsWith(keyPrefix)) {
            String name;
            int dot = key.indexOf(46, keyPrefix.length());
            String string = name = dot == -1 ? key.substring(keyPrefix.length()) : key.substring(keyPrefix.length(), dot);
            if ("enabled".equals(name)) {
                return;
            }
            if ("properties".equals(name)) {
                return;
            }
            if (!MainHelper.isServiceEnabled(keyPrefix, name, prop)) {
                return;
            }
            String prefix = dot == -1 ? "" : key.substring(0, dot + 1);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            if ("enabled".equalsIgnoreCase(option)) {
                return;
            }
            MainHelper.validateOptionAndValue(key, option, value);
            Iterable<Object> targets = supplier.apply(name);
            for (Object target : targets) {
                PropertyOptionKey pok = new PropertyOptionKey(target, prefix);
                Map values = properties.computeIfAbsent(pok, k -> new LinkedHashMap());
                values.put(MainHelper.optionKey(option), value);
            }
        }
    }

    public static boolean isServiceEnabled(String prefix, String name, Properties properties) {
        ObjectHelper.notNull(prefix, "prefix");
        ObjectHelper.notNull(name, "name");
        ObjectHelper.notNull(properties, "properties");
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String group = properties.getProperty(prefix + "enabled", "true");
        String item = properties.getProperty(prefix + name + ".enabled", group);
        return Boolean.parseBoolean(item);
    }

    public static void validateOptionAndValue(String key, String option, String value) {
        if (ObjectHelper.isEmpty(option)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because option is empty");
        }
        if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because value is empty");
        }
    }

    private static void loadLines(InputStream in, Set<String> lines, Function<String, String> func) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(in);
             LineNumberReader reader = new LineNumberReader(isr);){
            String line;
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                lines.add(func.apply(line));
            }
        }
    }
}

