/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.ConfigureRouteTemplates;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesConfigurer.class);
    private RoutesCollector routesCollector;
    private CamelBeanPostProcessor beanPostProcessor;
    private List<RoutesBuilder> routesBuilders;
    private String packageScanRouteBuilders;
    private String routesBuilderClasses;
    private String javaRoutesExcludePattern;
    private String javaRoutesIncludePattern;
    private String routesExcludePattern;
    private String routesIncludePattern;

    public List<RoutesBuilder> getRoutesBuilders() {
        return this.routesBuilders;
    }

    public void setRoutesBuilders(List<RoutesBuilder> routesBuilders) {
        this.routesBuilders = routesBuilders;
    }

    public String getPackageScanRouteBuilders() {
        return this.packageScanRouteBuilders;
    }

    public void setPackageScanRouteBuilders(String packageScanRouteBuilders) {
        this.packageScanRouteBuilders = packageScanRouteBuilders;
    }

    public String getRoutesBuilderClasses() {
        return this.routesBuilderClasses;
    }

    public void setRoutesBuilderClasses(String routesBuilderClasses) {
        this.routesBuilderClasses = routesBuilderClasses;
    }

    public String getJavaRoutesExcludePattern() {
        return this.javaRoutesExcludePattern;
    }

    public void setJavaRoutesExcludePattern(String javaRoutesExcludePattern) {
        this.javaRoutesExcludePattern = javaRoutesExcludePattern;
    }

    public String getJavaRoutesIncludePattern() {
        return this.javaRoutesIncludePattern;
    }

    public void setJavaRoutesIncludePattern(String javaRoutesIncludePattern) {
        this.javaRoutesIncludePattern = javaRoutesIncludePattern;
    }

    public String getRoutesExcludePattern() {
        return this.routesExcludePattern;
    }

    public void setRoutesExcludePattern(String routesExcludePattern) {
        this.routesExcludePattern = routesExcludePattern;
    }

    public String getRoutesIncludePattern() {
        return this.routesIncludePattern;
    }

    public void setRoutesIncludePattern(String routesIncludePattern) {
        this.routesIncludePattern = routesIncludePattern;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public CamelBeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    public void setBeanPostProcessor(CamelBeanPostProcessor beanPostProcessor) {
        this.beanPostProcessor = beanPostProcessor;
    }

    public void configureRoutes(CamelContext camelContext) throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        if (this.getRoutesBuilders() != null) {
            routes.addAll(this.getRoutesBuilders());
        }
        if (this.getRoutesBuilderClasses() != null) {
            String[] routeClasses;
            for (String routeClass : routeClasses = this.getRoutesBuilderClasses().split(",")) {
                Class<RoutesBuilder> routeClazz = camelContext.getClassResolver().resolveClass(routeClass, RoutesBuilder.class);
                if (routeClazz == null) {
                    LOG.warn("Unable to resolve class: {}", (Object)routeClass);
                    continue;
                }
                RoutesBuilder builder = camelContext.getInjector().newInstance(routeClazz);
                routes.add(builder);
            }
        }
        if (this.getPackageScanRouteBuilders() != null) {
            String[] pkgs = this.getPackageScanRouteBuilders().split(",");
            Set<Class<?>> set = camelContext.adapt(ExtendedCamelContext.class).getPackageScanClassResolver().findImplementations(RoutesBuilder.class, pkgs);
            for (Class<?> routeClazz : set) {
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RoutesBuilder) {
                    routes.add((RoutesBuilder)builder);
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", routeClazz);
            }
        }
        if (this.getRoutesCollector() != null) {
            try {
                LOG.debug("RoutesCollectorEnabled: {}", (Object)this.getRoutesCollector());
                Collection<RoutesBuilder> routesFromRegistry = this.getRoutesCollector().collectRoutesFromRegistry(camelContext, this.getJavaRoutesExcludePattern(), this.getJavaRoutesIncludePattern());
                routes.addAll(routesFromRegistry);
                StopWatch stopWatch = new StopWatch();
                Collection<RoutesBuilder> routesFromDirectory = this.getRoutesCollector().collectRoutesFromDirectory(camelContext, this.getRoutesExcludePattern(), this.getRoutesIncludePattern());
                routes.addAll(routesFromDirectory);
                if (!routesFromDirectory.isEmpty()) {
                    LOG.info("Loaded {} additional RoutesBuilder from: {} (took {})", new Object[]{routesFromDirectory.size(), this.getRoutesIncludePattern(), TimeUtils.printDuration(stopWatch.taken())});
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
        if (this.getBeanPostProcessor() != null) {
            for (RoutesBuilder routesBuilder : routes) {
                this.getBeanPostProcessor().postProcessBeforeInitialization(routesBuilder, routesBuilder.getClass().getName());
                this.getBeanPostProcessor().postProcessAfterInitialization(routesBuilder, routesBuilder.getClass().getName());
            }
        }
        routes.sort(OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            LOG.debug("Adding routes into CamelContext from RoutesBuilder: {}", (Object)routesBuilder);
            camelContext.addRoutes(routesBuilder);
        }
        Set<ConfigureRouteTemplates> set = camelContext.getRegistry().findByType(ConfigureRouteTemplates.class);
        for (ConfigureRouteTemplates crt : set) {
            LOG.debug("Configuring route templates via: {}", (Object)crt);
            crt.configure(camelContext);
        }
    }
}

