/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.nio;

import com.rabbitmq.client.MalformedFrameException;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FrameBuilder {
    private static final int PAYLOAD_OFFSET = 7;
    protected final ReadableByteChannel channel;
    protected final ByteBuffer applicationBuffer;
    private final int[] frameBuffer = new int[3];
    private int frameType;
    private int frameChannel;
    private byte[] framePayload;
    private int bytesRead = 0;

    public FrameBuilder(ReadableByteChannel channel, ByteBuffer buffer) {
        this.channel = channel;
        this.applicationBuffer = buffer;
    }

    public Frame readFrame() throws IOException {
        while (this.somethingToRead()) {
            if (this.bytesRead == 0) {
                this.frameType = this.readFromBuffer();
                if (this.frameType == 65) {
                    this.handleProtocolVersionMismatch();
                }
            } else if (this.bytesRead == 1) {
                this.frameBuffer[0] = this.readFromBuffer();
            } else if (this.bytesRead == 2) {
                this.frameChannel = (this.frameBuffer[0] << 8) + this.readFromBuffer();
            } else if (this.bytesRead == 3) {
                this.frameBuffer[0] = this.readFromBuffer();
            } else if (this.bytesRead == 4) {
                this.frameBuffer[1] = this.readFromBuffer();
            } else if (this.bytesRead == 5) {
                this.frameBuffer[2] = this.readFromBuffer();
            } else if (this.bytesRead == 6) {
                int framePayloadSize = (this.frameBuffer[0] << 24) + (this.frameBuffer[1] << 16) + (this.frameBuffer[2] << 8) + this.readFromBuffer();
                this.framePayload = new byte[framePayloadSize];
            } else if (this.bytesRead >= 7 && this.bytesRead < this.framePayload.length + 7) {
                this.framePayload[this.bytesRead - 7] = (byte)this.readFromBuffer();
            } else {
                if (this.bytesRead == this.framePayload.length + 7) {
                    int frameEndMarker = this.readFromBuffer();
                    if (frameEndMarker != 206) {
                        throw new MalformedFrameException("Bad frame end marker: " + frameEndMarker);
                    }
                    this.bytesRead = 0;
                    return new Frame(this.frameType, this.frameChannel, this.framePayload);
                }
                throw new IllegalStateException("Number of read bytes incorrect: " + this.bytesRead);
            }
            ++this.bytesRead;
        }
        return null;
    }

    protected boolean somethingToRead() throws IOException {
        if (!this.applicationBuffer.hasRemaining()) {
            this.applicationBuffer.clear();
            int read = NioHelper.read(this.channel, this.applicationBuffer);
            this.applicationBuffer.flip();
            return read > 0;
        }
        return true;
    }

    private int readFromBuffer() {
        return this.applicationBuffer.get() & 0xFF;
    }

    private void handleProtocolVersionMismatch() throws IOException {
        MalformedFrameException x;
        int expectedBytesCount;
        byte[] expectedBytes = new byte[]{77, 81, 80};
        for (expectedBytesCount = 0; this.somethingToRead() && expectedBytesCount < 3; ++expectedBytesCount) {
            int nextByte = this.readFromBuffer();
            if (nextByte == expectedBytes[expectedBytesCount]) continue;
            throw new MalformedFrameException("Invalid AMQP protocol header from server: expected character " + expectedBytes[expectedBytesCount] + ", got " + nextByte);
        }
        if (expectedBytesCount != 3) {
            throw new MalformedFrameException("Invalid AMQP protocol header from server: read only " + (expectedBytesCount + 1) + " byte(s) instead of 4");
        }
        int[] signature = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!this.somethingToRead()) {
                throw new MalformedFrameException("Invalid AMQP protocol header from server");
            }
            signature[i2] = this.readFromBuffer();
        }
        if (signature[0] == 1 && signature[1] == 1 && signature[2] == 8 && signature[3] == 0) {
            x = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server is 0-8");
        } else {
            String sig = "";
            for (int i3 = 0; i3 < 4; ++i3) {
                if (i3 != 0) {
                    sig = sig + ",";
                }
                sig = sig + signature[i3];
            }
            x = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server sent signature " + sig);
        }
        throw x;
    }

    public boolean isUnderflowHandlingEnabled() {
        return false;
    }
}

