/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.net.URISyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.spi.annotations.SendDynamic;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@SendDynamic(value="spring-rabbitmq")
public class SpringRabbitMQSendDynamicAware
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private String scheme;

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    @Override
    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, null, null);
    }

    @Override
    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String originalRoutingKey;
        String routingKey;
        String originalExchangeName;
        String answer = null;
        String exchangeName = this.parseExchangeName(entry.getUri());
        if (exchangeName != null && !exchangeName.equals(originalExchangeName = this.parseExchangeName(entry.getOriginalUri()))) {
            answer = entry.getUri();
            answer = StringHelper.replaceFirst(answer, exchangeName, originalExchangeName);
        }
        if ((routingKey = this.parseRoutingKey(entry.getUri())) != null && !routingKey.equals(originalRoutingKey = this.parseRoutingKey(entry.getOriginalUri()))) {
            if (answer == null) {
                answer = entry.getUri();
            }
            answer = StringHelper.replaceFirst(answer, "routingKey=" + routingKey, "routingKey=" + originalRoutingKey);
        }
        return answer;
    }

    @Override
    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String s = exchange.getMessage().getHeader("CamelSpringRabbitmqExchangeOverrideName", String.class);
        final String destinationName = s != null ? s : this.parseExchangeName(entry.getUri());
        s = exchange.getMessage().getHeader("CamelSpringRabbitmqRoutingOverrideKey", String.class);
        final String routingKey = s != null ? s : this.parseRoutingKey(entry.getUri());
        return new Processor(){

            @Override
            public void process(Exchange exchange) throws Exception {
                if (destinationName != null) {
                    exchange.getMessage().setHeader("CamelSpringRabbitmqExchangeOverrideName", destinationName);
                }
                if (routingKey != null) {
                    exchange.getMessage().setHeader("CamelSpringRabbitmqRoutingOverrideKey", routingKey);
                }
            }
        };
    }

    @Override
    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    private String parseExchangeName(String uri) {
        int pos = (uri = uri.replaceFirst(this.scheme + "://", ":")).indexOf(63);
        if (pos != -1) {
            uri = uri.substring(0, pos);
        }
        if ((pos = uri.indexOf(58)) != -1) {
            return uri.substring(pos + 1);
        }
        return null;
    }

    private String parseRoutingKey(String uri) throws URISyntaxException {
        String query = URISupport.extractQuery(uri);
        if (query != null) {
            Object key = URISupport.parseQuery(query).get("routingKey");
            return key != null ? key.toString() : null;
        }
        return null;
    }
}

