/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.springrabbit.SpringRabbitMQEndpoint;
import org.apache.camel.support.PollingConsumerSupport;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class SpringRabbitPollingConsumer
extends PollingConsumerSupport {
    private RabbitTemplate template;
    private SpringRabbitMQEndpoint jmsEndpoint;

    public SpringRabbitPollingConsumer(SpringRabbitMQEndpoint endpoint, RabbitTemplate template) {
        super(endpoint);
        this.jmsEndpoint = endpoint;
        this.template = template;
    }

    @Override
    public SpringRabbitMQEndpoint getEndpoint() {
        return (SpringRabbitMQEndpoint)super.getEndpoint();
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    @Override
    public Exchange receive() {
        return this.receive(-1L);
    }

    @Override
    public Exchange receive(long timeout) {
        try {
            Message message = timeout == 0L ? this.template.receive(this.jmsEndpoint.getQueues()) : this.template.receive(this.jmsEndpoint.getQueues(), timeout);
            if (message != null) {
                return this.getEndpoint().createExchange(message);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
        return null;
    }

    @Override
    protected void doInit() throws Exception {
        if (this.getEndpoint().getQueues() == null) {
            throw new IllegalArgumentException("Queues must be configured when using PollingConsumer");
        }
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

