/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;

public final class StringQuoteHelper {
    private StringQuoteHelper() {
    }

    public static String doubleQuote(String text) {
        return StringQuoteHelper.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return StringQuoteHelper.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }

    public static String[] splitSafeQuote(String input, char separator) {
        return StringQuoteHelper.splitSafeQuote(input, separator, true);
    }

    public static String[] splitSafeQuote(String input, char separator, boolean trim) {
        if (input == null) {
            return null;
        }
        if (input.indexOf(separator) == -1) {
            if (input.length() > 1) {
                boolean doubleQuoted;
                char ch = input.charAt(0);
                char ch2 = input.charAt(input.length() - 1);
                boolean singleQuoted = ch == '\'' && ch2 == '\'';
                boolean bl = doubleQuoted = ch == '\"' && ch2 == '\"';
                if (singleQuoted || doubleQuoted) {
                    input = input.substring(1, input.length() - 1);
                }
            }
            return new String[]{trim ? input.trim() : input};
        }
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean skipLeadingWhitespace = true;
        for (int i2 = 0; i2 < input.length(); ++i2) {
            String text;
            boolean isQuoting;
            char ch = input.charAt(i2);
            char prev = i2 > 0 ? input.charAt(i2 - 1) : (char)'\u0000';
            boolean bl = isQuoting = singleQuoted || doubleQuoted;
            if (!doubleQuoted && ch == '\'') {
                if (singleQuoted && prev == ch && sb.length() == 0) {
                    answer.add("");
                }
                if (i2 == input.length() - 1 && singleQuoted && sb.length() > 0) {
                    text = sb.toString();
                    answer.add(text);
                    sb.setLength(0);
                }
                singleQuoted = !singleQuoted;
                continue;
            }
            if (!singleQuoted && ch == '\"') {
                if (doubleQuoted && prev == ch && sb.length() == 0) {
                    answer.add("");
                }
                if (i2 == input.length() - 1 && doubleQuoted && sb.length() > 0) {
                    text = sb.toString();
                    answer.add(text);
                    sb.setLength(0);
                }
                doubleQuoted = !doubleQuoted;
                continue;
            }
            if (!isQuoting && separator != ' ' && ch == ' ') {
                if (skipLeadingWhitespace) {
                    continue;
                }
            } else if (!isQuoting && ch == separator) {
                if (sb.length() <= 0) continue;
                text = sb.toString();
                if (trim) {
                    text = text.trim();
                }
                answer.add(text);
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            String text = sb.toString();
            if (trim) {
                text = text.trim();
            }
            answer.add(text);
        }
        return answer.toArray(new String[answer.size()]);
    }
}

