/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.impl.NetworkConnection;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import java.io.IOException;
import java.net.InetAddress;
import org.springframework.amqp.AmqpResourceNotAvailableException;
import org.springframework.amqp.rabbit.connection.AutoRecoverConnectionNotCurrentlyOpenException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.util.ObjectUtils;

public class SimpleConnection
implements Connection,
NetworkConnection {
    private final com.rabbitmq.client.Connection delegate;
    private final int closeTimeout;
    private volatile boolean explicitlyClosed;

    public SimpleConnection(com.rabbitmq.client.Connection delegate, int closeTimeout) {
        this.delegate = delegate;
        this.closeTimeout = closeTimeout;
    }

    @Override
    public Channel createChannel(boolean transactional) {
        try {
            Channel channel = this.delegate.createChannel();
            if (channel == null) {
                throw new AmqpResourceNotAvailableException("The channelMax limit is reached. Try later.");
            }
            if (transactional) {
                channel.txSelect();
            }
            return channel;
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.explicitlyClosed = true;
            this.delegate.close(this.closeTimeout);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public boolean isOpen() {
        if (!this.explicitlyClosed && this.delegate instanceof AutorecoveringConnection && !this.delegate.isOpen()) {
            throw new AutoRecoverConnectionNotCurrentlyOpenException("Auto recovery connection is not currently open");
        }
        return this.delegate != null && this.delegate.isOpen();
    }

    @Override
    public int getLocalPort() {
        if (this.delegate instanceof NetworkConnection) {
            return ((NetworkConnection)((Object)this.delegate)).getLocalPort();
        }
        return 0;
    }

    @Override
    public void addBlockedListener(BlockedListener listener) {
        this.delegate.addBlockedListener(listener);
    }

    @Override
    public boolean removeBlockedListener(BlockedListener listener) {
        return this.delegate.removeBlockedListener(listener);
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.delegate instanceof NetworkConnection) {
            return ((NetworkConnection)((Object)this.delegate)).getLocalAddress();
        }
        return null;
    }

    @Override
    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public com.rabbitmq.client.Connection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return "SimpleConnection@" + ObjectUtils.getIdentityHexString((Object)this) + " [delegate=" + this.delegate + ", localPort= " + this.getLocalPort() + "]";
    }
}

