/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class AntPathMatcher {
    public static final AntPathMatcher INSTANCE = new AntPathMatcher();
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator = "/";

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator != null ? pathSeparator : DEFAULT_PATH_SEPARATOR;
    }

    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    public boolean match(String pattern, String path) {
        return this.match(pattern, path, true);
    }

    public boolean anyMatch(String[] patterns, String path) {
        return this.anyMatch(patterns, path, true);
    }

    public boolean anyMatch(String[] patterns, String path, boolean isCaseSensitive) {
        if (patterns == null) {
            return false;
        }
        if (patterns.length == 0) {
            return false;
        }
        for (String pattern : patterns) {
            if (!this.match(pattern, path, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public boolean matchStart(String pattern, String path) {
        return this.matchStart(pattern, path, true);
    }

    public boolean match(String pattern, String path, boolean isCaseSensitive) {
        return this.doMatch(pattern, path, true, isCaseSensitive);
    }

    public boolean matchStart(String pattern, String path, boolean isCaseSensitive) {
        return this.doMatch(pattern, path, false, isCaseSensitive);
    }

    protected boolean doMatch(String pattern, String path, boolean fullMatch, boolean isCaseSensitive) {
        String patDir;
        int pathIdxStart;
        if (path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pattDirs = AntPathMatcher.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathDirs = AntPathMatcher.tokenizeToStringArray(path, this.pathSeparator);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patDir, pathDirs[pathIdxStart], isCaseSensitive)) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) ? path.endsWith(this.pathSeparator) : !path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i2 = pattIdxStart; i2 <= pattIdxEnd; ++i2) {
                if (pattDirs[i2].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd], isCaseSensitive)) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i3 = pattIdxStart; i3 <= pattIdxEnd; ++i3) {
                if (pattDirs[i3].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = pattIdxStart + 1; i4 <= pattIdxEnd; ++i4) {
                if (!pattDirs[i4].equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i5 + j];
                    if (!this.matchStrings(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = pathIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i6 = pattIdxStart; i6 <= pattIdxEnd; ++i6) {
            if (pattDirs[i6].equals("**")) continue;
            return false;
        }
        return true;
    }

    private boolean matchStrings(String pattern, String str, boolean caseSensitive) {
        char ch;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char c : patArr) {
            if (c != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?' || !AntPathMatcher.different(caseSensitive, ch2, strArr[i2])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && AntPathMatcher.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && AntPathMatcher.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i4 = patIdxStart; i4 <= patIdxEnd; ++i4) {
                if (patArr[i4] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i5 = patIdxStart + 1; i5 <= patIdxEnd; ++i5) {
                if (patArr[i5] != '*') continue;
                patIdxTmp = i5;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i6 = 0; i6 <= strLength - patLength; ++i6) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && AntPathMatcher.different(caseSensitive, ch, strArr[strIdxStart + i6 + j])) continue block8;
                }
                foundIdx = strIdxStart + i6;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i7 = patIdxStart; i7 <= patIdxEnd; ++i7) {
            if (patArr[i7] == '*') continue;
            return false;
        }
        return true;
    }

    public String extractPathWithinPattern(String pattern, String path) {
        int i2;
        if (path == null) {
            return null;
        }
        String[] patternParts = AntPathMatcher.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathParts = AntPathMatcher.tokenizeToStringArray(path, this.pathSeparator);
        StringBuilder buffer = new StringBuilder();
        int puts = 0;
        for (i2 = 0; i2 < patternParts.length; ++i2) {
            String patternPart = patternParts[i2];
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1 || pathParts.length < i2 + 1) continue;
            if (puts > 0 || i2 == 0 && !pattern.startsWith(this.pathSeparator)) {
                buffer.append(this.pathSeparator);
            }
            buffer.append(pathParts[i2]);
            ++puts;
        }
        for (i2 = patternParts.length; i2 < pathParts.length; ++i2) {
            if (puts > 0 || i2 > 0) {
                buffer.append(this.pathSeparator);
            }
            buffer.append(pathParts[i2]);
        }
        return buffer.toString();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.trim()).length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    public String determineRootDir(String location) {
        int prefixEnd = location.indexOf(58) + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }
}

