/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class SimpleResourceHolder {
    private static final String FOR_KEY = "] for key [";
    private static final String BOUND_TO_THREAD = "] bound to thread [";
    private static final Log LOGGER = LogFactory.getLog(SimpleResourceHolder.class);
    private static final ThreadLocal<Map<Object, Object>> RESOURCES = new NamedThreadLocal("Simple resources");
    private static final ThreadLocal<Map<Object, Deque<Object>>> STACK = new NamedThreadLocal("Simple resources");

    public static Map<Object, Object> getResources() {
        Map<Object, Object> map = RESOURCES.get();
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public static boolean has(Object key) {
        Object value = SimpleResourceHolder.doGet(key);
        return value != null;
    }

    @Nullable
    public static Object get(Object key) {
        Object value = SimpleResourceHolder.doGet(key);
        if (value != null && LOGGER.isTraceEnabled()) {
            LOGGER.trace("Retrieved value [" + value + FOR_KEY + key + BOUND_TO_THREAD + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    private static Object doGet(Object actualKey) {
        Map<Object, Object> map = RESOURCES.get();
        if (map == null) {
            return null;
        }
        return map.get(actualKey);
    }

    public static void bind(Object key, Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        Map<Object, Object> map = RESOURCES.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
            RESOURCES.set(map);
        }
        Object oldValue = map.put(key, value);
        Assert.isNull((Object)oldValue, () -> "Already value [" + oldValue + FOR_KEY + key + BOUND_TO_THREAD + Thread.currentThread().getName() + "]");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Bound value [" + value + FOR_KEY + key + "] to thread [" + Thread.currentThread().getName() + "]");
        }
    }

    public static void push(Object key, Object value) {
        Object currentValue = SimpleResourceHolder.get(key);
        if (currentValue == null) {
            SimpleResourceHolder.bind(key, value);
        } else {
            Map<Object, Deque<Object>> stack = STACK.get();
            if (stack == null) {
                stack = new HashMap<Object, Deque<Object>>();
                STACK.set(stack);
            }
            stack.computeIfAbsent(key, k -> new LinkedList());
            stack.get(key).push(currentValue);
            SimpleResourceHolder.unbind(key);
            SimpleResourceHolder.bind(key, value);
        }
    }

    @Nullable
    public static Object pop(Object key) {
        Deque<Object> deque;
        Object popped = SimpleResourceHolder.unbind(key);
        Map<Object, Deque<Object>> stack = STACK.get();
        if (stack != null && (deque = stack.get(key)) != null && deque.size() > 0) {
            Object previousValue = deque.pop();
            if (previousValue != null) {
                SimpleResourceHolder.bind(key, previousValue);
            }
            if (deque.isEmpty()) {
                STACK.remove();
            }
        }
        return popped;
    }

    public static Object unbind(Object key) throws IllegalStateException {
        Object value = SimpleResourceHolder.unbindIfPossible(key);
        Assert.notNull((Object)value, () -> "No value for key [" + key + BOUND_TO_THREAD + Thread.currentThread().getName() + "]");
        return value;
    }

    @Nullable
    public static Object unbindIfPossible(Object key) {
        Map<Object, Object> map = RESOURCES.get();
        if (map == null) {
            return null;
        }
        Object value = map.remove(key);
        if (map.isEmpty()) {
            RESOURCES.remove();
        }
        if (value != null && LOGGER.isTraceEnabled()) {
            LOGGER.trace("Removed value [" + value + FOR_KEY + key + "] from thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    public static void clear() {
        RESOURCES.remove();
        STACK.remove();
    }

    private SimpleResourceHolder() {
    }
}

