/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.Jackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.ProjectingMessageConverter;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public abstract class AbstractJackson2MessageConverter
extends AbstractMessageConverter
implements BeanClassLoaderAware,
SmartMessageConverter {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    protected final ObjectMapper objectMapper;
    private MimeType supportedContentType;
    private String supportedCTCharset;
    @Nullable
    private ClassMapper classMapper = null;
    private Charset defaultCharset = DEFAULT_CHARSET;
    private boolean typeMapperSet;
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private Jackson2JavaTypeMapper javaTypeMapper = new DefaultJackson2JavaTypeMapper();
    private boolean useProjectionForInterfaces;
    private ProjectingMessageConverter projectingConverter;
    private boolean charsetIsUtf8 = true;
    private boolean assumeSupportedContentType = true;
    private boolean alwaysConvertToInferredType;
    private boolean nullAsOptionalEmpty;

    protected AbstractJackson2MessageConverter(ObjectMapper objectMapper, MimeType contentType, String ... trustedPackages) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.objectMapper = objectMapper;
        this.supportedContentType = contentType;
        this.supportedCTCharset = this.supportedContentType.getParameter("charset");
        ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setTrustedPackages(trustedPackages);
    }

    protected MimeType getSupportedContentType() {
        return this.supportedContentType;
    }

    public void setSupportedContentType(MimeType supportedContentType) {
        Assert.notNull((Object)supportedContentType, (String)"'supportedContentType' cannot be null");
        this.supportedContentType = supportedContentType;
        this.supportedCTCharset = this.supportedContentType.getParameter("charset");
    }

    public void setNullAsOptionalEmpty(boolean nullAsOptionalEmpty) {
        this.nullAsOptionalEmpty = nullAsOptionalEmpty;
    }

    @Nullable
    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public void setClassMapper(ClassMapper classMapper) {
        this.classMapper = classMapper;
    }

    public void setDefaultCharset(@Nullable String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? Charset.forName(defaultCharset) : DEFAULT_CHARSET;
        this.charsetIsUtf8 = this.defaultCharset.equals(StandardCharsets.UTF_8);
    }

    public String getDefaultCharset() {
        return this.defaultCharset.name();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (!this.typeMapperSet) {
            ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setBeanClassLoader(classLoader);
        }
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Jackson2JavaTypeMapper getJavaTypeMapper() {
        return this.javaTypeMapper;
    }

    public boolean isTypeMapperSet() {
        return this.typeMapperSet;
    }

    public void setJavaTypeMapper(Jackson2JavaTypeMapper javaTypeMapper) {
        Assert.notNull((Object)javaTypeMapper, (String)"'javaTypeMapper' cannot be null");
        this.javaTypeMapper = javaTypeMapper;
        this.typeMapperSet = true;
    }

    public Jackson2JavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.javaTypeMapper.getTypePrecedence();
    }

    public void setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence typePrecedence) {
        if (this.typeMapperSet) {
            throw new IllegalStateException("When providing your own type mapper, you should set the precedence on it");
        }
        if (!(this.javaTypeMapper instanceof DefaultJackson2JavaTypeMapper)) {
            throw new IllegalStateException("Type precedence is available with the DefaultJackson2JavaTypeMapper");
        }
        ((DefaultJackson2JavaTypeMapper)this.javaTypeMapper).setTypePrecedence(typePrecedence);
    }

    public void setAlwaysConvertToInferredType(boolean alwaysAttemptConversion) {
        this.alwaysConvertToInferredType = alwaysAttemptConversion;
    }

    protected boolean isUseProjectionForInterfaces() {
        return this.useProjectionForInterfaces;
    }

    public void setUseProjectionForInterfaces(boolean useProjectionForInterfaces) {
        this.useProjectionForInterfaces = useProjectionForInterfaces;
        if (useProjectionForInterfaces) {
            if (!ClassUtils.isPresent((String)"org.springframework.data.projection.ProjectionFactory", (ClassLoader)this.classLoader)) {
                throw new IllegalStateException("'spring-data-commons' is required to use Projection Interfaces");
            }
            this.projectingConverter = new ProjectingMessageConverter(this.objectMapper);
        }
    }

    public void setAssumeSupportedContentType(boolean assumeSupportedContentType) {
        this.assumeSupportedContentType = assumeSupportedContentType;
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        return this.fromMessage(message, null);
    }

    @Override
    public Object fromMessage(Message message, @Nullable Object conversionHint) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (this.assumeSupportedContentType && (contentType == null || contentType.equals("application/octet-stream")) || contentType != null && contentType.contains(this.supportedContentType.getSubtype())) {
                String encoding = this.determineEncoding(properties, contentType);
                content = this.doFromMessage(message, conversionHint, properties, encoding);
            } else if (this.log.isWarnEnabled()) {
                this.log.warn("Could not convert incoming message with content-type [" + contentType + "], '" + this.supportedContentType.getSubtype() + "' keyword missing.");
            }
        }
        if (content == null) {
            content = this.nullAsOptionalEmpty ? Optional.empty() : (Object)message.getBody();
        }
        return content;
    }

    private String determineEncoding(MessageProperties properties, @Nullable String contentType) {
        String encoding = properties.getContentEncoding();
        if (encoding == null && contentType != null) {
            try {
                MimeType mimeType = MimeTypeUtils.parseMimeType((String)contentType);
                if (mimeType != null) {
                    encoding = mimeType.getParameter("charset");
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (encoding == null) {
            encoding = this.supportedCTCharset != null ? this.supportedCTCharset : this.getDefaultCharset();
        }
        return encoding;
    }

    private Object doFromMessage(Message message, Object conversionHint, MessageProperties properties, String encoding) {
        Object content = null;
        try {
            content = this.convertContent(message, conversionHint, properties, encoding);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        return content;
    }

    private Object convertContent(Message message, Object conversionHint, MessageProperties properties, String encoding) throws IOException {
        Object content = null;
        JavaType inferredType = this.javaTypeMapper.getInferredType(properties);
        if (inferredType != null && this.useProjectionForInterfaces && inferredType.isInterface() && !inferredType.getRawClass().getPackage().getName().startsWith("java.util")) {
            content = this.projectingConverter.convert(message, inferredType.getRawClass());
            properties.setProjectionUsed(true);
        } else if (inferredType != null && this.alwaysConvertToInferredType) {
            content = this.tryConverType(message, encoding, inferredType);
        }
        if (content == null) {
            if (conversionHint instanceof ParameterizedTypeReference) {
                content = this.convertBytesToObject(message.getBody(), encoding, this.objectMapper.getTypeFactory().constructType(((ParameterizedTypeReference)conversionHint).getType()));
            } else if (this.getClassMapper() == null) {
                JavaType targetJavaType = this.getJavaTypeMapper().toJavaType(message.getMessageProperties());
                content = this.convertBytesToObject(message.getBody(), encoding, targetJavaType);
            } else {
                Class<?> targetClass = this.getClassMapper().toClass(message.getMessageProperties());
                content = this.convertBytesToObject(message.getBody(), encoding, targetClass);
            }
        }
        return content;
    }

    @Nullable
    private Object tryConverType(Message message, String encoding, JavaType inferredType) {
        try {
            return this.convertBytesToObject(message.getBody(), encoding, inferredType);
        }
        catch (Exception e) {
            this.log.trace("Cannot create possibly abstract container contents; falling back to headers", e);
            return null;
        }
    }

    private Object convertBytesToObject(byte[] body, String encoding, JavaType targetJavaType) throws IOException {
        if (this.supportedCTCharset != null) {
            return this.objectMapper.readValue(body, targetJavaType);
        }
        String contentAsString = new String(body, encoding);
        return this.objectMapper.readValue(contentAsString, targetJavaType);
    }

    private Object convertBytesToObject(byte[] body, String encoding, Class<?> targetClass) throws IOException {
        if (this.supportedCTCharset != null) {
            return this.objectMapper.readValue(body, this.objectMapper.constructType(targetClass));
        }
        String contentAsString = new String(body, encoding);
        return this.objectMapper.readValue(contentAsString, this.objectMapper.constructType(targetClass));
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties) throws MessageConversionException {
        return this.createMessage(objectToConvert, messageProperties, null);
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties, @Nullable Type genericType) throws MessageConversionException {
        byte[] bytes;
        try {
            if (this.charsetIsUtf8 && this.supportedCTCharset == null) {
                bytes = this.objectMapper.writeValueAsBytes(objectToConvert);
            } else {
                String jsonString = this.objectMapper.writeValueAsString(objectToConvert);
                String encoding = this.supportedCTCharset != null ? this.supportedCTCharset : this.getDefaultCharset();
                bytes = jsonString.getBytes(encoding);
            }
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        messageProperties.setContentType(this.supportedContentType.toString());
        if (this.supportedCTCharset == null) {
            messageProperties.setContentEncoding(this.getDefaultCharset());
        }
        messageProperties.setContentLength(bytes.length);
        if (this.getClassMapper() == null) {
            JavaType type = this.objectMapper.constructType(genericType == null ? objectToConvert.getClass() : genericType);
            if (genericType != null && !type.isContainerType() && Modifier.isAbstract(type.getRawClass().getModifiers())) {
                type = this.objectMapper.constructType(objectToConvert.getClass());
            }
            this.getJavaTypeMapper().fromJavaType(type, messageProperties);
        } else {
            this.getClassMapper().fromClass(objectToConvert.getClass(), messageProperties);
        }
        return new Message(bytes, messageProperties);
    }
}

