/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.query.SortQueryBuilder;

public class RedisClient {
    private final RedisTemplate<String, Object> redisTemplate;

    public RedisClient(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    public void hmset(String key, Map<String, Object> param) {
        this.redisTemplate.opsForHash().putAll(key, param);
    }

    public Collection<Object> hmget(String key, Collection<String> fields) {
        return this.redisTemplate.opsForHash().multiGet(key, fields);
    }

    public Set<String> hkeys(String key) {
        return this.redisTemplate.opsForHash().keys(key);
    }

    public Long hlen(String key) {
        return this.redisTemplate.opsForHash().size(key);
    }

    public Long hincrBy(String key, String field, Long value) {
        return this.redisTemplate.opsForHash().increment(key, field, value);
    }

    public Map<String, Object> hgetAll(String key) {
        return this.redisTemplate.opsForHash().entries(key);
    }

    public Boolean hexists(String key, String field) {
        return this.redisTemplate.opsForHash().hasKey(key, field);
    }

    public Object hget(String key, String field) {
        return this.redisTemplate.opsForHash().get(key, field);
    }

    public void hdel(String key, String field) {
        this.redisTemplate.opsForHash().delete(key, field);
    }

    public void hset(String key, String field, Object value) {
        this.redisTemplate.opsForHash().put(key, field, value);
    }

    public void quit() {
        this.redisTemplate.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.close();
                return null;
            }
        });
    }

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get(key);
    }

    public Collection<Object> hvals(String key) {
        return this.redisTemplate.opsForHash().values(key);
    }

    public Boolean hsetnx(String key, String field, Object value) {
        return this.redisTemplate.opsForHash().putIfAbsent(key, field, value);
    }

    public Long decr(String key) {
        return this.redisTemplate.opsForValue().increment(key, -1L);
    }

    public Long decrby(String key, Long value) {
        return this.redisTemplate.opsForValue().increment(key, -value.longValue());
    }

    public Long incr(String key) {
        return this.redisTemplate.opsForValue().increment(key, 1L);
    }

    public Long incrby(String key, Long value) {
        return this.redisTemplate.opsForValue().increment(key, value);
    }

    public String getrange(String key, Long start, Long end) {
        return this.redisTemplate.opsForValue().get(key, start, end);
    }

    public Long strlen(String key) {
        return this.redisTemplate.opsForValue().size(key);
    }

    public List<Object> mget(Collection<String> fields) {
        return this.redisTemplate.opsForValue().multiGet(fields);
    }

    public void mset(Map<String, Object> map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    public void msetnx(Map<String, Object> map) {
        this.redisTemplate.opsForValue().multiSetIfAbsent(map);
    }

    public Object getset(String key, Object value) {
        return this.redisTemplate.opsForValue().getAndSet(key, value);
    }

    public Boolean setnx(String key, Object value) {
        return this.redisTemplate.opsForValue().setIfAbsent(key, value);
    }

    public void setex(String key, Object value, Long timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set(key, value, timeout, timeUnit);
    }

    public void setex(String key, Object value, Long offset) {
        this.redisTemplate.opsForValue().set(key, value, offset);
    }

    public void setbit(final String key, final Long offset, final Boolean value) {
        this.redisTemplate.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setBit(key.getBytes(), offset, value);
                return null;
            }
        });
    }

    public Boolean getbit(final String key, final Long offset) {
        return this.redisTemplate.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.getBit(key.getBytes(), offset);
            }
        });
    }

    public Integer append(String key, String value) {
        return this.redisTemplate.opsForValue().append(key, value);
    }

    public void multi() {
        this.redisTemplate.multi();
    }

    public void unwatch() {
        this.redisTemplate.unwatch();
    }

    public void discard() {
        this.redisTemplate.discard();
    }

    public void exec() {
        this.redisTemplate.exec();
    }

    public void watch(Collection<String> keys) {
        this.redisTemplate.watch(keys);
    }

    public Long sadd(String key, Object value) {
        return this.redisTemplate.opsForSet().add(key, (Object[])new Object[]{value});
    }

    public Long scard(String key) {
        return this.redisTemplate.opsForSet().size(key);
    }

    public Set<Object> sdiff(String key, Collection<String> keys) {
        return this.redisTemplate.opsForSet().difference(key, keys);
    }

    public void sdiffstore(String key, Collection<String> keys, String destinations) {
        this.redisTemplate.opsForSet().differenceAndStore(key, keys, destinations);
    }

    public Set<Object> sinter(String key, Collection<String> keys) {
        return this.redisTemplate.opsForSet().intersect(key, keys);
    }

    public void sinterstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForSet().intersectAndStore(key, keys, destination);
    }

    public Boolean sismember(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember(key, value);
    }

    public Set<Object> smembers(String key) {
        return this.redisTemplate.opsForSet().members(key);
    }

    public Boolean smove(String key, Object value, String destination) {
        return this.redisTemplate.opsForSet().move(key, value, destination);
    }

    public Object spop(String key) {
        return this.redisTemplate.opsForSet().pop(key);
    }

    public Object srandmember(String key) {
        return this.redisTemplate.opsForSet().randomMember(key);
    }

    public Long srem(String key, Object value) {
        return this.redisTemplate.opsForSet().remove(key, value);
    }

    public Set<Object> sunion(String key, Collection<String> keys) {
        return this.redisTemplate.opsForSet().union(key, keys);
    }

    public void sunionstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForSet().unionAndStore(key, keys, destination);
    }

    public String echo(final String value) {
        return this.redisTemplate.execute(new RedisCallback<String>(){

            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                return new String(connection.echo(value.getBytes()));
            }
        });
    }

    public String ping() {
        return this.redisTemplate.execute(new RedisCallback<String>(){

            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.ping();
            }
        });
    }

    public void publish(String channel, Object message) {
        this.redisTemplate.convertAndSend(channel, message);
    }

    public Object lpop(String key) {
        return this.redisTemplate.opsForList().leftPop(key);
    }

    public Object blpop(String key, Long timeout) {
        return this.redisTemplate.opsForList().leftPop(key, timeout, TimeUnit.SECONDS);
    }

    public Object brpoplpush(String key, String destination, Long timeout) {
        return this.redisTemplate.opsForList().rightPopAndLeftPush(key, destination, timeout, TimeUnit.SECONDS);
    }

    public Object rpoplpush(String key, String destination) {
        return this.redisTemplate.opsForList().rightPopAndLeftPush(key, destination);
    }

    public Object lindex(String key, Long index) {
        return this.redisTemplate.opsForList().index(key, index);
    }

    public Long linsert(String key, Object value, String pivot, String position) {
        if ("BEFORE".equals(position)) {
            return this.redisTemplate.opsForList().leftPush(key, pivot, value);
        }
        if ("AFTER".equals(position)) {
            return this.redisTemplate.opsForList().rightPush(key, pivot, value);
        }
        throw new IllegalArgumentException("Wrong position: " + position);
    }

    public Object rpop(String key) {
        return this.redisTemplate.opsForList().rightPop(key);
    }

    public Object brpop(String key, Long timeout) {
        return this.redisTemplate.opsForList().rightPop(key, timeout, TimeUnit.SECONDS);
    }

    public Long llen(String key) {
        return this.redisTemplate.opsForList().size(key);
    }

    public List<Object> lrange(String key, Long start, Long end) {
        return this.redisTemplate.opsForList().range(key, start, end);
    }

    public Long lrem(String key, Object value, Long count) {
        return this.redisTemplate.opsForList().remove(key, count, value);
    }

    public void lset(String key, Object value, Long index) {
        this.redisTemplate.opsForList().set(key, index, value);
    }

    public void ltrim(String key, Long start, Long end) {
        this.redisTemplate.opsForList().trim(key, start, end);
    }

    public Long rpush(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush(key, value);
    }

    public Long rpushx(String key, Object value) {
        return this.redisTemplate.opsForList().rightPushIfPresent(key, value);
    }

    public Long lpush(String key, Object value) {
        return this.redisTemplate.opsForList().leftPush(key, value);
    }

    public void del(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public Boolean exists(String key) {
        return this.redisTemplate.hasKey(key);
    }

    public Boolean expire(String key, Long timeout) {
        return this.redisTemplate.expire(key, timeout, TimeUnit.SECONDS);
    }

    public Boolean expireat(String key, Long seconds) {
        return this.redisTemplate.expireAt(key, new Date(seconds * 1000L));
    }

    public Collection<String> keys(String pattern) {
        return this.redisTemplate.keys(pattern);
    }

    public Boolean move(String key, Integer db) {
        return this.redisTemplate.move(key, db);
    }

    public Boolean persist(String key) {
        return this.redisTemplate.persist(key);
    }

    public Boolean pexpire(String key, Long timeout) {
        return this.redisTemplate.expire(key, timeout, TimeUnit.MILLISECONDS);
    }

    public Boolean pexpireat(String key, Long millis) {
        return this.redisTemplate.expireAt(key, new Date(millis));
    }

    public String randomkey() {
        return this.redisTemplate.randomKey();
    }

    public void rename(String key, String value) {
        this.redisTemplate.rename(key, value);
    }

    public Boolean renamenx(String key, String value) {
        return this.redisTemplate.renameIfAbsent(key, value);
    }

    public Long ttl(String key) {
        return this.redisTemplate.getExpire(key);
    }

    public String type(String key) {
        return this.redisTemplate.type(key).toString();
    }

    public List<Object> sort(String key) {
        SortQuery sortQuery = SortQueryBuilder.sort(key).build();
        return this.redisTemplate.sort(sortQuery);
    }

    public Boolean zadd(String key, Object value, Double score) {
        return this.redisTemplate.opsForZSet().add(key, value, score);
    }

    public Long zcard(String key) {
        return this.redisTemplate.opsForZSet().size(key);
    }

    public Long zcount(String key, Double min, Double max) {
        return this.redisTemplate.opsForZSet().count(key, min, max);
    }

    public Double zincrby(String key, Object value, Double increment) {
        return this.redisTemplate.opsForZSet().incrementScore(key, value, increment);
    }

    public void zinterstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForZSet().intersectAndStore(key, keys, destination);
    }

    public Object zrange(String key, Long start, Long end, Boolean withScore) {
        if (withScore != null && withScore.booleanValue()) {
            return this.redisTemplate.opsForZSet().rangeWithScores(key, start, end);
        }
        return this.redisTemplate.opsForZSet().range(key, start, end);
    }

    public Set<Object> zrangebyscore(String key, Double min, Double max) {
        return this.redisTemplate.opsForZSet().rangeByScore(key, min, max);
    }

    public Long zrank(String key, Object value) {
        return this.redisTemplate.opsForZSet().rank(key, value);
    }

    public Long zrem(String key, Object value) {
        return this.redisTemplate.opsForZSet().remove(key, value);
    }

    public void zremrangebyrank(String key, Long start, Long end) {
        this.redisTemplate.opsForZSet().removeRange(key, start, end);
    }

    public void zremrangebyscore(String key, Long start, Long end) {
        this.redisTemplate.opsForZSet().removeRangeByScore(key, start.longValue(), end.longValue());
    }

    public Object zrevrange(String key, Long start, Long end, Boolean withScore) {
        if (withScore != null && withScore.booleanValue()) {
            return this.redisTemplate.opsForZSet().reverseRangeWithScores(key, start, end);
        }
        return this.redisTemplate.opsForZSet().reverseRange(key, start, end);
    }

    public Set<Object> zrevrangebyscore(String key, Double min, Double max) {
        return this.redisTemplate.opsForZSet().reverseRangeByScore(key, min, max);
    }

    public Long zrevrank(String key, Object value) {
        return this.redisTemplate.opsForZSet().reverseRank(key, value);
    }

    public void zunionstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForZSet().unionAndStore(key, keys, destination);
    }
}

