/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.component.redis.RedisEndpoint;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.Topic;

public class RedisConsumer
extends DirectConsumer
implements MessageListener {
    private final RedisConfiguration redisConfiguration;

    public RedisConsumer(RedisEndpoint redisEndpoint, Processor processor, RedisConfiguration redisConfiguration) {
        super((Endpoint)redisEndpoint, processor);
        this.redisConfiguration = redisConfiguration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        Collection<Topic> topics = this.toTopics(this.redisConfiguration.getChannels());
        this.redisConfiguration.getListenerContainer().addMessageListener((MessageListener)this, topics);
    }

    private Collection<Topic> toTopics(String channels) {
        String[] channelsArrays = channels.split(",");
        ArrayList<Topic> topics = new ArrayList<Topic>();
        for (String channel : channelsArrays) {
            if (Command.PSUBSCRIBE.toString().equals(this.redisConfiguration.getCommand())) {
                topics.add(new PatternTopic(channel));
                continue;
            }
            if (Command.SUBSCRIBE.toString().equals(this.redisConfiguration.getCommand())) {
                topics.add(new ChannelTopic(channel));
                continue;
            }
            throw new RuntimeException("Unsupported Command");
        }
        return topics;
    }

    @Override
    public void onMessage(Message message, byte[] pattern) {
        try {
            Exchange exchange = this.getEndpoint().createExchange();
            this.setChannel(exchange, message.getChannel());
            this.setPattern(exchange, pattern);
            this.setBody(exchange, message.getBody());
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setBody(Exchange exchange, byte[] body) {
        if (body != null) {
            exchange.getIn().setBody(this.redisConfiguration.getSerializer().deserialize(body));
        }
    }

    private void setPattern(Exchange exchange, byte[] pattern) {
        if (pattern != null) {
            exchange.getIn().setHeader("CamelRedis.Pattern", (Object)pattern);
        }
    }

    private void setChannel(Exchange exchange, byte[] message) throws UnsupportedEncodingException {
        if (message != null) {
            exchange.getIn().setHeader("CamelRedis.Channel", (Object)new String(message, "UTF8"));
        }
    }
}

