/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractConfigAttributeRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.configurers.AbstractInterceptUrlConfigurer;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class UrlAuthorizationConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractInterceptUrlConfigurer<UrlAuthorizationConfigurer<H>, H> {
    private final StandardInterceptUrlRegistry REGISTRY;

    public UrlAuthorizationConfigurer(ApplicationContext context) {
        this.REGISTRY = new StandardInterceptUrlRegistry(context);
    }

    public StandardInterceptUrlRegistry getRegistry() {
        return this.REGISTRY;
    }

    @Override
    public UrlAuthorizationConfigurer<H> withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    @Override
    final List<AccessDecisionVoter<? extends Object>> getDecisionVoters(H http) {
        ArrayList<AccessDecisionVoter<? extends Object>> decisionVoters = new ArrayList<AccessDecisionVoter<? extends Object>>();
        decisionVoters.add(new RoleVoter());
        decisionVoters.add(new AuthenticatedVoter());
        return decisionVoters;
    }

    @Override
    FilterInvocationSecurityMetadataSource createMetadataSource(H http) {
        return new DefaultFilterInvocationSecurityMetadataSource(this.REGISTRY.createRequestMap());
    }

    private StandardInterceptUrlRegistry addMapping(Iterable<? extends RequestMatcher> requestMatchers, Collection<ConfigAttribute> configAttributes) {
        for (RequestMatcher requestMatcher : requestMatchers) {
            this.REGISTRY.addMapping(new AbstractConfigAttributeRequestMatcherRegistry.UrlMapping(requestMatcher, configAttributes));
        }
        return this.REGISTRY;
    }

    private static String hasRole(String role) {
        Assert.isTrue((!role.startsWith("ROLE_") ? 1 : 0) != 0, (String)(role + " should not start with ROLE_ since ROLE_ is automatically prepended when using hasRole. Consider using hasAuthority or access instead."));
        return "ROLE_" + role;
    }

    private static String[] hasAnyRole(String ... roles) {
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = "ROLE_" + roles[i];
        }
        return roles;
    }

    private static String[] hasAnyAuthority(String ... authorities) {
        return authorities;
    }

    public class AuthorizedUrl {
        private final List<? extends RequestMatcher> requestMatchers;

        private AuthorizedUrl(List<? extends RequestMatcher> requestMatchers) {
            Assert.notEmpty(requestMatchers, (String)"requestMatchers must contain at least one value");
            this.requestMatchers = requestMatchers;
        }

        public StandardInterceptUrlRegistry hasRole(String role) {
            return this.access(UrlAuthorizationConfigurer.hasRole(role));
        }

        public StandardInterceptUrlRegistry hasAnyRole(String ... roles) {
            return this.access(UrlAuthorizationConfigurer.hasAnyRole(roles));
        }

        public StandardInterceptUrlRegistry hasAuthority(String authority) {
            return this.access(authority);
        }

        public StandardInterceptUrlRegistry hasAnyAuthority(String ... authorities) {
            return this.access(UrlAuthorizationConfigurer.hasAnyAuthority(authorities));
        }

        public StandardInterceptUrlRegistry anonymous() {
            return this.hasRole("ROLE_ANONYMOUS");
        }

        public StandardInterceptUrlRegistry access(String ... attributes) {
            UrlAuthorizationConfigurer.this.addMapping(this.requestMatchers, SecurityConfig.createList(attributes));
            return UrlAuthorizationConfigurer.this.REGISTRY;
        }

        protected List<? extends RequestMatcher> getMatchers() {
            return this.requestMatchers;
        }
    }

    public final class MvcMatchersAuthorizedUrl
    extends AuthorizedUrl {
        private MvcMatchersAuthorizedUrl(List<MvcRequestMatcher> requestMatchers) {
            super(requestMatchers);
        }

        public AuthorizedUrl servletPath(String servletPath) {
            for (MvcRequestMatcher mvcRequestMatcher : this.getMatchers()) {
                mvcRequestMatcher.setServletPath(servletPath);
            }
            return this;
        }
    }

    public class StandardInterceptUrlRegistry
    extends AbstractInterceptUrlConfigurer.AbstractInterceptUrlRegistry<StandardInterceptUrlRegistry, AuthorizedUrl> {
        private StandardInterceptUrlRegistry(ApplicationContext context) {
            super(UrlAuthorizationConfigurer.this);
            this.setApplicationContext(context);
        }

        @Override
        public MvcMatchersAuthorizedUrl mvcMatchers(HttpMethod method, String ... mvcPatterns) {
            return new MvcMatchersAuthorizedUrl(this.createMvcMatchers(method, mvcPatterns));
        }

        @Override
        public MvcMatchersAuthorizedUrl mvcMatchers(String ... patterns) {
            return this.mvcMatchers((HttpMethod)null, patterns);
        }

        @Override
        protected final AuthorizedUrl chainRequestMatchersInternal(List<RequestMatcher> requestMatchers) {
            return new AuthorizedUrl(requestMatchers);
        }

        public StandardInterceptUrlRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            UrlAuthorizationConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }

        public H and() {
            return (HttpSecurityBuilder)UrlAuthorizationConfigurer.this.and();
        }
    }
}

