/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.GeneralSecurityException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.client.ActionCallback;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.client.core.SoapActionCallback;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponentsMessageSender;
import org.springframework.ws.transport.http.HttpUrlConnection;
import org.springframework.ws.transport.http.HttpUrlConnectionMessageSender;

public class SpringWebserviceProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringWebserviceProducer.class);
    private static final SourceExtractor<Object> SOURCE_EXTRACTOR = new NoopSourceExtractor();
    private static final XmlConverter XML_CONVERTER = new XmlConverter();

    public SpringWebserviceProducer(Endpoint endpoint) {
        super(endpoint);
        SpringWebserviceProducer.prepareMessageSenders(this.getEndpoint().getConfiguration());
    }

    public SpringWebserviceEndpoint getEndpoint() {
        return (SpringWebserviceEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        Source sourcePayload = (Source)exchange.getIn().getMandatoryBody(Source.class);
        String endpointUriHeader = (String)exchange.getIn().getHeader("CamelSpringWebserviceEndpointUri", String.class);
        String soapActionHeader = (String)exchange.getIn().getHeader("CamelSpringWebserviceSoapAction", String.class);
        URI wsAddressingActionHeader = (URI)exchange.getIn().getHeader("CamelSpringWebserviceAddressingAction", URI.class);
        URI wsReplyToHeader = (URI)exchange.getIn().getHeader("CamelSpringWebserviceAddressingReplyTo", URI.class);
        URI wsFaultToHeader = (URI)exchange.getIn().getHeader("CamelSpringWebserviceAddressingFaultTo", URI.class);
        Source soapHeaderSource = (Source)exchange.getIn().getHeader("CamelSpringWebserviceSoapHeader", Source.class);
        DefaultWebserviceMessageCallback callback = new DefaultWebserviceMessageCallback(soapActionHeader, wsAddressingActionHeader, wsReplyToHeader, wsFaultToHeader, soapHeaderSource, this.getEndpoint().getConfiguration(), exchange);
        Object body = endpointUriHeader != null ? this.getEndpoint().getConfiguration().getWebServiceTemplate().sendSourceAndReceive(endpointUriHeader, sourcePayload, callback, SOURCE_EXTRACTOR) : this.getEndpoint().getConfiguration().getWebServiceTemplate().sendSourceAndReceive(sourcePayload, callback, SOURCE_EXTRACTOR);
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(body);
        } else {
            exchange.getIn().setBody(body);
        }
    }

    private static void prepareMessageSenders(SpringWebserviceConfiguration configuration) {
        if (configuration.getTimeout() <= -1 && configuration.getSslContextParameters() == null) {
            return;
        }
        WebServiceTemplate webServiceTemplate = configuration.getWebServiceTemplate();
        WebServiceMessageSender[] messageSenders = webServiceTemplate.getMessageSenders();
        for (int i = 0; i < messageSenders.length; ++i) {
            WebServiceMessageSender messageSender = messageSenders[i];
            if (messageSender instanceof HttpComponentsMessageSender) {
                if (configuration.getSslContextParameters() != null) {
                    LOG.warn("Not applying SSLContextParameters based configuration to HttpComponentsMessageSender.  If you are using this MessageSender, which you are not by default, you will need to configure SSL using the Commons HTTP 3.x Protocol registry.");
                }
                if (configuration.getTimeout() <= -1) continue;
                if (messageSender.getClass().equals(HttpComponentsMessageSender.class)) {
                    ((HttpComponentsMessageSender)messageSender).setReadTimeout(configuration.getTimeout());
                    continue;
                }
                LOG.warn("Not applying timeout configuration to HttpComponentsMessageSender based implementation.  You are using what appears to be a custom MessageSender, which you are not doing by default. You will need configure timeout on your own.");
                continue;
            }
            if (messageSender.getClass().equals(HttpUrlConnectionMessageSender.class)) {
                messageSenders[i] = new AbstractHttpWebServiceMessageSenderDecorator((HttpUrlConnectionMessageSender)messageSender, configuration);
                continue;
            }
            LOG.warn("Ignoring the timeout and SSLContextParameters options for {}.  You will need to configure these options directly on your custom configured WebServiceMessageSender", (Object)messageSender);
        }
    }

    private static class NoopSourceExtractor
    implements SourceExtractor<Object> {
        private NoopSourceExtractor() {
        }

        @Override
        public Object extractData(Source source) throws IOException, TransformerException {
            return source;
        }
    }

    protected static class DefaultWebserviceMessageCallback
    implements WebServiceMessageCallback {
        private final String soapActionHeader;
        private final URI wsAddressingActionHeader;
        private final URI wsReplyToHeader;
        private final URI wsFaultToHeader;
        private final Source soapHeaderSource;
        private final SpringWebserviceConfiguration configuration;
        private final Exchange exchange;

        public DefaultWebserviceMessageCallback(String soapAction, URI wsAddressingAction, URI wsReplyTo, URI wsFaultTo, Source soapHeaderSource, SpringWebserviceConfiguration configuration, Exchange exchange) {
            this.soapActionHeader = soapAction;
            this.wsAddressingActionHeader = wsAddressingAction;
            this.wsReplyToHeader = wsReplyTo;
            this.wsFaultToHeader = wsFaultTo;
            this.soapHeaderSource = soapHeaderSource;
            this.configuration = configuration;
            this.exchange = exchange;
        }

        @Override
        public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
            URI wsFaultTo;
            String soapAction;
            String string = soapAction = this.soapActionHeader != null ? this.soapActionHeader : this.configuration.getSoapAction();
            if (soapAction != null) {
                new SoapActionCallback(soapAction).doWithMessage(message);
            }
            URI wsAddressingAction = this.wsAddressingActionHeader != null ? this.wsAddressingActionHeader : this.configuration.getWsAddressingAction();
            URI wsReplyTo = this.wsReplyToHeader != null ? this.wsReplyToHeader : this.configuration.getReplyTo();
            URI uRI = wsFaultTo = this.wsFaultToHeader != null ? this.wsFaultToHeader : this.configuration.getFaultTo();
            if (this.soapHeaderSource != null) {
                SoapHeader header = ((SoapMessage)message).getSoapHeader();
                XML_CONVERTER.toResult(this.soapHeaderSource, header.getResult());
            }
            if (wsAddressingAction != null) {
                ActionCallback actionCallback = new ActionCallback(wsAddressingAction);
                if (wsReplyTo != null) {
                    actionCallback.setReplyTo(new EndpointReference(wsReplyTo));
                }
                if (wsFaultTo != null) {
                    actionCallback.setFaultTo(new EndpointReference(wsFaultTo));
                }
                actionCallback.doWithMessage(message);
            }
            this.configuration.getMessageFilter().filterProducer(this.exchange, message);
        }
    }

    protected static final class AbstractHttpWebServiceMessageSenderDecorator
    extends AbstractHttpWebServiceMessageSender {
        private final AbstractHttpWebServiceMessageSender delegate;
        private final SpringWebserviceConfiguration configuration;
        private SSLContext sslContext;

        public AbstractHttpWebServiceMessageSenderDecorator(AbstractHttpWebServiceMessageSender delegate, SpringWebserviceConfiguration configuration) {
            this.delegate = delegate;
            this.configuration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebServiceConnection createConnection(URI uri) throws IOException {
            WebServiceConnection wsc = this.delegate.createConnection(uri);
            if (wsc instanceof HttpUrlConnection) {
                HttpURLConnection connection = ((HttpUrlConnection)wsc).getConnection();
                if (this.configuration.getTimeout() > -1) {
                    connection.setReadTimeout(this.configuration.getTimeout());
                }
                if (this.configuration.getSslContextParameters() != null && connection instanceof HttpsURLConnection) {
                    try {
                        AbstractHttpWebServiceMessageSenderDecorator abstractHttpWebServiceMessageSenderDecorator = this;
                        synchronized (abstractHttpWebServiceMessageSenderDecorator) {
                            if (this.sslContext == null) {
                                this.sslContext = this.configuration.getSslContextParameters().createSSLContext();
                            }
                        }
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeCamelException("Error creating SSLContext based on SSLContextParameters.", (Throwable)e);
                    }
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslContext.getSocketFactory());
                }
            } else {
                throw new RuntimeCamelException("Unsupported delegate.  Delegate must return a org.springframework.ws.transport.http.HttpUrlConnection.  Found " + wsc.getClass());
            }
            return wsc;
        }

        @Override
        public boolean isAcceptGzipEncoding() {
            return this.delegate.isAcceptGzipEncoding();
        }

        @Override
        public void setAcceptGzipEncoding(boolean acceptGzipEncoding) {
            this.delegate.setAcceptGzipEncoding(acceptGzipEncoding);
        }

        @Override
        public boolean supports(URI uri) {
            return this.delegate.supports(uri);
        }
    }
}

