/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.converter;

import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.support.JmsHeaderMapper;
import org.springframework.jms.support.SimpleJmsHeaderMapper;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagingMessageConverter
implements MessageConverter,
InitializingBean {
    private MessageConverter payloadConverter;
    private JmsHeaderMapper headerMapper;

    public MessagingMessageConverter() {
        this(new SimpleMessageConverter(), new SimpleJmsHeaderMapper());
    }

    public MessagingMessageConverter(MessageConverter payloadConverter) {
        this(payloadConverter, new SimpleJmsHeaderMapper());
    }

    public MessagingMessageConverter(MessageConverter payloadConverter, JmsHeaderMapper headerMapper) {
        Assert.notNull((Object)payloadConverter, (String)"PayloadConverter must not be null");
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.payloadConverter = payloadConverter;
        this.headerMapper = headerMapper;
    }

    public void setPayloadConverter(MessageConverter payloadConverter) {
        this.payloadConverter = payloadConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.payloadConverter, (String)"Property 'payloadConverter' is required");
        Assert.notNull((Object)this.headerMapper, (String)"Property 'headerMapper' is required");
    }

    @Override
    public javax.jms.Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        if (!(object instanceof Message)) {
            throw new IllegalArgumentException("Could not convert [" + object + "] - only [" + Message.class.getName() + "] is handled by this converter");
        }
        Message input = (Message)object;
        MessageHeaders headers = input.getHeaders();
        Object conversionHint = headers != null ? headers.get("conversionHint") : null;
        javax.jms.Message reply = this.createMessageForPayload(input.getPayload(), session, conversionHint);
        this.headerMapper.fromHeaders(headers, reply);
        return reply;
    }

    @Override
    public Object fromMessage(javax.jms.Message message) throws JMSException, MessageConversionException {
        if (message == null) {
            return null;
        }
        MessageHeaders mappedHeaders = this.extractHeaders(message);
        Object convertedObject = this.extractPayload(message);
        MessageBuilder<Object> builder = convertedObject instanceof Message ? MessageBuilder.fromMessage((Message)convertedObject) : MessageBuilder.withPayload(convertedObject);
        return builder.copyHeadersIfAbsent(mappedHeaders).build();
    }

    protected Object extractPayload(javax.jms.Message message) throws JMSException {
        return this.payloadConverter.fromMessage(message);
    }

    @Deprecated
    protected javax.jms.Message createMessageForPayload(Object payload, Session session) throws JMSException {
        return this.payloadConverter.toMessage(payload, session);
    }

    protected javax.jms.Message createMessageForPayload(Object payload, Session session, Object conversionHint) throws JMSException {
        return this.createMessageForPayload(payload, session);
    }

    protected final MessageHeaders extractHeaders(javax.jms.Message message) {
        return this.headerMapper.toHeaders(message);
    }
}

