/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.DefaultResourceResolverChain;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.UrlPathHelper;

public class ResourceUrlProvider
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, ResourceHttpRequestHandler> handlerMap = new LinkedHashMap<String, ResourceHttpRequestHandler>();
    private boolean autodetect = true;

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    @Deprecated
    public UrlPathHelper getPathHelper() {
        return this.urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setHandlerMap(Map<String, ResourceHttpRequestHandler> handlerMap) {
        if (handlerMap != null) {
            this.handlerMap.clear();
            this.handlerMap.putAll(handlerMap);
            this.autodetect = false;
        }
    }

    public Map<String, ResourceHttpRequestHandler> getHandlerMap() {
        return this.handlerMap;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isAutodetect()) {
            this.handlerMap.clear();
            this.detectResourceHandlers(event.getApplicationContext());
            if (this.handlerMap.isEmpty() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No resource handling mappings found");
            }
            if (!this.handlerMap.isEmpty()) {
                this.autodetect = false;
            }
        }
    }

    protected void detectResourceHandlers(ApplicationContext appContext) {
        this.logger.debug((Object)"Looking for resource handler mappings");
        Map map = appContext.getBeansOfType(SimpleUrlHandlerMapping.class);
        ArrayList handlerMappings = new ArrayList(map.values());
        AnnotationAwareOrderComparator.sort(handlerMappings);
        for (SimpleUrlHandlerMapping hm : handlerMappings) {
            for (String pattern : hm.getHandlerMap().keySet()) {
                Object handler = hm.getHandlerMap().get(pattern);
                if (!(handler instanceof ResourceHttpRequestHandler)) continue;
                ResourceHttpRequestHandler resourceHandler = (ResourceHttpRequestHandler)handler;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found resource handler mapping: URL pattern=\"" + pattern + "\", locations=" + resourceHandler.getLocations() + ", resolvers=" + resourceHandler.getResourceResolvers()));
                }
                this.handlerMap.put(pattern, resourceHandler);
            }
        }
    }

    public final String getForRequestUrl(HttpServletRequest request, String requestUrl) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for request URL \"" + requestUrl + "\""));
        }
        int prefixIndex = this.getLookupPathIndex(request);
        int suffixIndex = this.getEndPathIndex(requestUrl);
        String prefix = requestUrl.substring(0, prefixIndex);
        String suffix = requestUrl.substring(suffixIndex);
        String lookupPath = requestUrl.substring(prefixIndex, suffixIndex);
        String resolvedLookupPath = this.getForLookupPath(lookupPath);
        return resolvedLookupPath != null ? prefix + resolvedLookupPath + suffix : null;
    }

    private int getLookupPathIndex(HttpServletRequest request) {
        UrlPathHelper pathHelper = this.getUrlPathHelper();
        String requestUri = pathHelper.getRequestUri(request);
        String lookupPath = pathHelper.getLookupPathForRequest(request);
        return requestUri.indexOf(lookupPath);
    }

    private int getEndPathIndex(String lookupPath) {
        int hashIndex;
        int suffixIndex = lookupPath.length();
        int queryIndex = lookupPath.indexOf("?");
        if (queryIndex > 0) {
            suffixIndex = queryIndex;
        }
        if ((hashIndex = lookupPath.indexOf("#")) > 0) {
            suffixIndex = Math.min(suffixIndex, hashIndex);
        }
        return suffixIndex;
    }

    public final String getForLookupPath(String lookupPath) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for lookup path \"" + lookupPath + "\""));
        }
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.handlerMap.keySet()) {
            if (!this.getPathMatcher().match(pattern, lookupPath)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator patternComparator = this.getPathMatcher().getPatternComparator(lookupPath);
            Collections.sort(matchingPatterns, patternComparator);
            for (String pattern : matchingPatterns) {
                ResourceHttpRequestHandler handler;
                DefaultResourceResolverChain chain;
                String resolved;
                String pathWithinMapping = this.getPathMatcher().extractPathWithinPattern(pattern, lookupPath);
                String pathMapping = lookupPath.substring(0, lookupPath.indexOf(pathWithinMapping));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Invoking ResourceResolverChain for URL pattern \"" + pattern + "\""));
                }
                if ((resolved = (chain = new DefaultResourceResolverChain((handler = this.handlerMap.get(pattern)).getResourceResolvers())).resolveUrlPath(pathWithinMapping, handler.getLocations())) == null) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Resolved public resource URL path \"" + resolved + "\""));
                }
                return pathMapping + resolved;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No matching resource mapping for lookup path \"" + lookupPath + "\""));
        }
        return null;
    }
}

