/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter;

import java.io.IOException;
import java.lang.reflect.Method;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.adapter.AbstractMethodEndpointAdapter;
import org.springframework.ws.support.MarshallingUtils;

@Deprecated
public class MarshallingMethodEndpointAdapter
extends AbstractMethodEndpointAdapter
implements InitializingBean {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public MarshallingMethodEndpointAdapter() {
    }

    public MarshallingMethodEndpointAdapter(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        if (!(marshaller instanceof Unmarshaller)) {
            throw new IllegalArgumentException("Marshaller [" + marshaller + "] does not implement the Unmarshaller " + "interface. Please set an Unmarshaller explicitly by using the " + "MarshallingMethodEndpointAdapter(Marshaller, Unmarshaller) constructor.");
        }
        this.setMarshaller(marshaller);
        this.setUnmarshaller((Unmarshaller)((Object)marshaller));
    }

    public MarshallingMethodEndpointAdapter(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.setMarshaller(marshaller);
        this.setUnmarshaller(unmarshaller);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public final void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public final void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getMarshaller(), (String)"marshaller is required");
        Assert.notNull((Object)this.getUnmarshaller(), (String)"unmarshaller is required");
    }

    @Override
    protected void invokeInternal(MessageContext messageContext, MethodEndpoint methodEndpoint) throws Exception {
        WebServiceMessage request = messageContext.getRequest();
        Object requestObject = this.unmarshalRequest(request);
        Object responseObject = methodEndpoint.invoke(requestObject);
        if (responseObject != null) {
            WebServiceMessage response = messageContext.getResponse();
            this.marshalResponse(responseObject, response);
        }
    }

    private Object unmarshalRequest(WebServiceMessage request) throws IOException {
        Object requestObject = MarshallingUtils.unmarshal(this.getUnmarshaller(), request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unmarshalled payload request to [" + requestObject + "]"));
        }
        return requestObject;
    }

    private void marshalResponse(Object responseObject, WebServiceMessage response) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Marshalling [" + responseObject + "] to response payload"));
        }
        MarshallingUtils.marshal(this.getMarshaller(), responseObject, response);
    }

    @Override
    protected boolean supportsInternal(MethodEndpoint methodEndpoint) {
        Method method = methodEndpoint.getMethod();
        return this.supportsReturnType(method) && this.supportsParameters(method);
    }

    private boolean supportsReturnType(Method method) {
        return Void.TYPE.equals(method.getReturnType()) || this.getMarshaller().supports(method.getReturnType());
    }

    private boolean supportsParameters(Method method) {
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return this.getUnmarshaller().supports(method.getParameterTypes()[0]);
    }
}

