/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadMethodProcessor;
import org.springframework.ws.stream.StreamingPayload;
import org.springframework.ws.stream.StreamingWebServiceMessage;
import org.springframework.xml.transform.TraxUtils;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractJaxb2PayloadMethodProcessor
extends AbstractPayloadMethodProcessor {
    private final ConcurrentMap<Class<?>, JAXBContext> jaxbContexts = new ConcurrentHashMap();

    @Override
    public final void handleReturnValue(MessageContext messageContext, MethodParameter returnType, Object returnValue) throws Exception {
        if (returnValue != null) {
            this.handleReturnValueInternal(messageContext, returnType, returnValue);
        }
    }

    protected abstract void handleReturnValueInternal(MessageContext var1, MethodParameter var2, Object var3) throws Exception;

    protected final void marshalToResponsePayload(MessageContext messageContext, Class<?> clazz, Object jaxbElement) throws JAXBException {
        WebServiceMessage response;
        Assert.notNull((Object)messageContext, (String)"'messageContext' must not be null");
        Assert.notNull(clazz, (String)"'clazz' must not be null");
        Assert.notNull((Object)jaxbElement, (String)"'jaxbElement' must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Marshalling [" + jaxbElement + "] to response payload"));
        }
        if ((response = messageContext.getResponse()) instanceof StreamingWebServiceMessage) {
            StreamingWebServiceMessage streamingResponse = (StreamingWebServiceMessage)response;
            JaxbStreamingPayload payload = new JaxbStreamingPayload(clazz, jaxbElement);
            streamingResponse.setStreamingPayload(payload);
        } else {
            Result responsePayload = response.getPayloadResult();
            try {
                Jaxb2ResultCallback callback = new Jaxb2ResultCallback(clazz, jaxbElement);
                TraxUtils.doWithResult(responsePayload, callback);
            }
            catch (Exception ex) {
                throw this.convertToJaxbException(ex);
            }
        }
    }

    protected final Object unmarshalFromRequestPayload(MessageContext messageContext, Class<?> clazz) throws JAXBException {
        Source requestPayload = this.getRequestPayload(messageContext);
        if (requestPayload == null) {
            return null;
        }
        try {
            Jaxb2SourceCallback callback = new Jaxb2SourceCallback(clazz);
            TraxUtils.doWithSource(requestPayload, callback);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unmarshalled payload request to [" + callback.result + "]"));
            }
            return callback.result;
        }
        catch (Exception ex) {
            throw this.convertToJaxbException(ex);
        }
    }

    protected final <T> JAXBElement<T> unmarshalElementFromRequestPayload(MessageContext messageContext, Class<T> clazz) throws JAXBException {
        Source requestPayload = this.getRequestPayload(messageContext);
        if (requestPayload == null) {
            return null;
        }
        try {
            JaxbElementSourceCallback<T> callback = new JaxbElementSourceCallback<T>(clazz);
            TraxUtils.doWithSource(requestPayload, callback);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unmarshalled payload request to [" + ((JaxbElementSourceCallback)callback).result + "]"));
            }
            return ((JaxbElementSourceCallback)callback).result;
        }
        catch (Exception ex) {
            throw this.convertToJaxbException(ex);
        }
    }

    private Source getRequestPayload(MessageContext messageContext) {
        WebServiceMessage request = messageContext.getRequest();
        return request != null ? request.getPayloadSource() : null;
    }

    private JAXBException convertToJaxbException(Exception ex) {
        if (ex instanceof JAXBException) {
            return (JAXBException)((Object)ex);
        }
        return new JAXBException((Throwable)ex);
    }

    protected Marshaller createMarshaller(JAXBContext jaxbContext) throws JAXBException {
        return jaxbContext.createMarshaller();
    }

    private Marshaller createMarshaller(Class<?> clazz) throws JAXBException {
        return this.createMarshaller(this.getJaxbContext(clazz));
    }

    protected Unmarshaller createUnmarshaller(JAXBContext jaxbContext) throws JAXBException {
        return jaxbContext.createUnmarshaller();
    }

    private Unmarshaller createUnmarshaller(Class<?> clazz) throws JAXBException {
        return this.createUnmarshaller(this.getJaxbContext(clazz));
    }

    private JAXBContext getJaxbContext(Class<?> clazz) throws JAXBException {
        Assert.notNull(clazz, (String)"'clazz' must not be null");
        JAXBContext jaxbContext = (JAXBContext)this.jaxbContexts.get(clazz);
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.jaxbContexts.putIfAbsent(clazz, jaxbContext);
        }
        return jaxbContext;
    }

    private class JaxbStreamingPayload
    implements StreamingPayload {
        private final Object jaxbElement;
        private final Marshaller marshaller;
        private final QName name;

        private JaxbStreamingPayload(Class<?> clazz, Object jaxbElement) throws JAXBException {
            JAXBContext jaxbContext = AbstractJaxb2PayloadMethodProcessor.this.getJaxbContext(clazz);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            this.jaxbElement = jaxbElement;
            JAXBIntrospector introspector = jaxbContext.createJAXBIntrospector();
            this.name = introspector.getElementName(jaxbElement);
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
            try {
                this.marshaller.marshal(this.jaxbElement, streamWriter);
            }
            catch (JAXBException ex) {
                throw new XMLStreamException("Could not marshal [" + this.jaxbElement + "]: " + ex.getMessage(), ex);
            }
        }
    }

    private class Jaxb2ResultCallback
    implements TraxUtils.ResultCallback {
        private final Marshaller marshaller;
        private final Object jaxbElement;

        private Jaxb2ResultCallback(Class<?> clazz, Object jaxbElement) throws JAXBException {
            this.marshaller = AbstractJaxb2PayloadMethodProcessor.this.createMarshaller(clazz);
            this.jaxbElement = jaxbElement;
        }

        @Override
        public void domResult(Node node) throws JAXBException {
            this.marshaller.marshal(this.jaxbElement, node);
        }

        @Override
        public void saxResult(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws JAXBException {
            this.marshaller.marshal(this.jaxbElement, contentHandler);
        }

        @Override
        public void staxResult(XMLEventWriter eventWriter) throws JAXBException {
            this.marshaller.marshal(this.jaxbElement, eventWriter);
        }

        @Override
        public void staxResult(XMLStreamWriter streamWriter) throws JAXBException {
            this.marshaller.marshal(this.jaxbElement, streamWriter);
        }

        @Override
        public void streamResult(OutputStream outputStream) throws JAXBException {
            this.marshaller.marshal(this.jaxbElement, outputStream);
        }

        @Override
        public void streamResult(Writer writer) throws JAXBException {
            this.marshaller.marshal(this.jaxbElement, writer);
        }

        @Override
        public void result(String systemId) throws Exception {
            this.marshaller.marshal(this.jaxbElement, (Result)new StreamResult(systemId));
        }
    }

    private class JaxbElementSourceCallback<T>
    implements TraxUtils.SourceCallback {
        private final Unmarshaller unmarshaller;
        private final Class<T> declaredType;
        private JAXBElement<T> result;

        public JaxbElementSourceCallback(Class<T> declaredType) throws JAXBException {
            this.unmarshaller = AbstractJaxb2PayloadMethodProcessor.this.createUnmarshaller(declaredType);
            this.declaredType = declaredType;
        }

        @Override
        public void domSource(Node node) throws JAXBException {
            this.result = this.unmarshaller.unmarshal(node, this.declaredType);
        }

        @Override
        public void saxSource(XMLReader reader, InputSource inputSource) throws JAXBException {
            this.result = this.unmarshaller.unmarshal((Source)new SAXSource(reader, inputSource), this.declaredType);
        }

        @Override
        public void staxSource(XMLEventReader eventReader) throws JAXBException {
            this.result = this.unmarshaller.unmarshal(eventReader, this.declaredType);
        }

        @Override
        public void staxSource(XMLStreamReader streamReader) throws JAXBException {
            this.result = this.unmarshaller.unmarshal(streamReader, this.declaredType);
        }

        @Override
        public void streamSource(InputStream inputStream) throws IOException, JAXBException {
            this.result = this.unmarshaller.unmarshal((Source)new StreamSource(inputStream), this.declaredType);
        }

        @Override
        public void streamSource(Reader reader) throws IOException, JAXBException {
            this.result = this.unmarshaller.unmarshal((Source)new StreamSource(reader), this.declaredType);
        }

        @Override
        public void source(String systemId) throws Exception {
            this.result = this.unmarshaller.unmarshal((Source)new StreamSource(systemId), this.declaredType);
        }
    }

    private class Jaxb2SourceCallback
    implements TraxUtils.SourceCallback {
        private final Unmarshaller unmarshaller;
        private Object result;

        public Jaxb2SourceCallback(Class<?> clazz) throws JAXBException {
            this.unmarshaller = AbstractJaxb2PayloadMethodProcessor.this.createUnmarshaller(clazz);
        }

        @Override
        public void domSource(Node node) throws JAXBException {
            this.result = this.unmarshaller.unmarshal(node);
        }

        @Override
        public void saxSource(XMLReader reader, InputSource inputSource) throws Exception {
            if (inputSource.getByteStream() == null && inputSource.getCharacterStream() == null && inputSource.getSystemId() == null) {
                UnmarshallerHandler handler = this.unmarshaller.getUnmarshallerHandler();
                reader.setContentHandler((ContentHandler)handler);
                reader.parse(inputSource);
                this.result = handler.getResult();
            } else {
                this.result = this.unmarshaller.unmarshal(inputSource);
            }
        }

        @Override
        public void staxSource(XMLEventReader eventReader) throws JAXBException {
            this.result = this.unmarshaller.unmarshal(eventReader);
        }

        @Override
        public void staxSource(XMLStreamReader streamReader) throws JAXBException {
            this.result = this.unmarshaller.unmarshal(streamReader);
        }

        @Override
        public void streamSource(InputStream inputStream) throws IOException, JAXBException {
            this.result = this.unmarshaller.unmarshal(inputStream);
        }

        @Override
        public void streamSource(Reader reader) throws IOException, JAXBException {
            this.result = this.unmarshaller.unmarshal(reader);
        }

        @Override
        public void source(String systemId) throws Exception {
            this.result = this.unmarshaller.unmarshal(new URL(systemId));
        }
    }
}

