/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.interceptor;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.validation.ValidationErrorHandler;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractValidatingInterceptor
extends TransformerObjectSupport
implements EndpointInterceptor,
InitializingBean {
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Resource[] schemas;
    private boolean validateRequest = true;
    private boolean validateResponse = false;
    private XmlValidator validator;
    private ValidationErrorHandler errorHandler;

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Resource[] getSchemas() {
        return this.schemas;
    }

    public void setSchema(Resource schema) {
        this.setSchemas(schema);
    }

    public void setSchemas(Resource ... schemas) {
        Assert.notEmpty((Object[])schemas, (String)"schemas must not be empty or null");
        for (Resource schema : schemas) {
            Assert.notNull((Object)schema, (String)"schema must not be null");
            Assert.isTrue((boolean)schema.exists(), (String)("schema \"" + schema + "\" does not exit"));
        }
        this.schemas = schemas;
    }

    public void setXsdSchema(XsdSchema schema) {
        this.validator = schema.createValidator();
    }

    public void setXsdSchemaCollection(XsdSchemaCollection schemaCollection) {
        this.validator = schemaCollection.createValidator();
    }

    public void setErrorHandler(ValidationErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setValidateRequest(boolean validateRequest) {
        this.validateRequest = validateRequest;
    }

    public void setValidateResponse(boolean validateResponse) {
        this.validateResponse = validateResponse;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.validator == null && !ObjectUtils.isEmpty((Object[])this.schemas)) {
            Assert.hasLength((String)this.schemaLanguage, (String)"schemaLanguage is required");
            for (Resource schema : this.schemas) {
                Assert.isTrue((boolean)schema.exists(), (String)("schema [" + schema + "] does not exist"));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Validating using " + StringUtils.arrayToCommaDelimitedString((Object[])this.schemas)));
            }
            this.validator = XmlValidatorFactory.createValidator(this.schemas, this.schemaLanguage);
        }
        Assert.notNull((Object)this.validator, (String)"Setting 'schema', 'schemas', 'xsdSchema', or 'xsdSchemaCollection' is required");
    }

    @Override
    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws IOException, SAXException, TransformerException {
        Source requestSource;
        if (this.validateRequest && (requestSource = this.getValidationRequestSource(messageContext.getRequest())) != null) {
            Object[] errors = this.validator.validate(requestSource, this.errorHandler);
            if (!ObjectUtils.isEmpty((Object[])errors)) {
                return this.handleRequestValidationErrors(messageContext, (SAXParseException[])errors);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Request message validated");
            }
        }
        return true;
    }

    protected boolean handleRequestValidationErrors(MessageContext messageContext, SAXParseException[] errors) throws TransformerException {
        for (SAXParseException error : errors) {
            this.logger.warn((Object)("XML validation error on request: " + error.getMessage()));
        }
        return false;
    }

    @Override
    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws IOException, SAXException {
        Source responseSource;
        if (this.validateResponse && (responseSource = this.getValidationResponseSource(messageContext.getResponse())) != null) {
            Object[] errors = this.validator.validate(responseSource, this.errorHandler);
            if (!ObjectUtils.isEmpty((Object[])errors)) {
                return this.handleResponseValidationErrors(messageContext, (SAXParseException[])errors);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Response message validated");
            }
        }
        return true;
    }

    protected boolean handleResponseValidationErrors(MessageContext messageContext, SAXParseException[] errors) {
        for (SAXParseException error : errors) {
            this.logger.error((Object)("XML validation error on response: " + error.getMessage()));
        }
        return false;
    }

    @Override
    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    @Override
    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) {
    }

    protected abstract Source getValidationRequestSource(WebServiceMessage var1);

    protected abstract Source getValidationResponseSource(WebServiceMessage var1);
}

