/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.mapping.AbstractMapBasedEndpointMapping;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Element;

public class XPathPayloadEndpointMapping
extends AbstractMapBasedEndpointMapping
implements InitializingBean {
    private String expressionString;
    private XPathExpression expression;
    private Map<String, String> namespaces;
    private TransformerFactory transformerFactory;

    public void setExpression(String expression) {
        this.expressionString = expression;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.expressionString, (String)"expression is required");
        this.expression = this.namespaces == null ? XPathExpressionFactory.createXPathExpression(this.expressionString) : XPathExpressionFactory.createXPathExpression(this.expressionString, this.namespaces);
        this.transformerFactory = TransformerFactory.newInstance();
    }

    @Override
    protected String getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        Element payloadElement = this.getMessagePayloadElement(messageContext.getRequest());
        return this.expression.evaluateAsString(payloadElement);
    }

    private Element getMessagePayloadElement(WebServiceMessage message) throws TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        DOMResult domResult = new DOMResult();
        transformer.transform(message.getPayloadSource(), domResult);
        return (Element)domResult.getNode().getFirstChild();
    }

    @Override
    protected boolean validateLookupKey(String key) {
        return StringUtils.hasLength((String)key);
    }
}

