/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.EndpointAwareWebServiceConnection;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;

public class HttpExchangeConnection
extends AbstractReceiverConnection
implements EndpointAwareWebServiceConnection,
FaultAwareWebServiceConnection {
    private final HttpExchange httpExchange;
    private ByteArrayOutputStream responseBuffer;
    private int responseStatusCode = 202;
    private boolean chunkedEncoding;

    protected HttpExchangeConnection(HttpExchange httpExchange) {
        Assert.notNull((Object)httpExchange, (String)"'httpExchange' must not be null");
        this.httpExchange = httpExchange;
    }

    public HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return this.httpExchange.getRequestURI();
    }

    void setChunkedEncoding(boolean chunkedEncoding) {
        this.chunkedEncoding = chunkedEncoding;
    }

    @Override
    public void endpointNotFound() {
        this.responseStatusCode = 404;
    }

    @Override
    public boolean hasError() throws IOException {
        return false;
    }

    @Override
    public String getErrorMessage() throws IOException {
        return null;
    }

    @Override
    public Iterator<String> getRequestHeaderNames() throws IOException {
        return this.httpExchange.getRequestHeaders().keySet().iterator();
    }

    @Override
    public Iterator<String> getRequestHeaders(String name) throws IOException {
        Object headers = this.httpExchange.getRequestHeaders().get(name);
        return headers != null ? headers.iterator() : Collections.emptyList().iterator();
    }

    @Override
    protected InputStream getRequestInputStream() throws IOException {
        return this.httpExchange.getRequestBody();
    }

    @Override
    public void addResponseHeader(String name, String value) throws IOException {
        this.httpExchange.getResponseHeaders().add(name, value);
    }

    @Override
    protected OutputStream getResponseOutputStream() throws IOException {
        if (this.chunkedEncoding) {
            this.httpExchange.sendResponseHeaders(this.responseStatusCode, 0L);
            return this.httpExchange.getResponseBody();
        }
        if (this.responseBuffer == null) {
            this.responseBuffer = new ByteArrayOutputStream();
        }
        return this.responseBuffer;
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        if (!this.chunkedEncoding) {
            byte[] buf = this.responseBuffer.toByteArray();
            this.httpExchange.sendResponseHeaders(this.responseStatusCode, buf.length);
            OutputStream responseBody = this.httpExchange.getResponseBody();
            FileCopyUtils.copy((byte[])buf, (OutputStream)responseBody);
        }
        this.responseBuffer = null;
    }

    @Override
    public void onClose() throws IOException {
        if (this.responseStatusCode == 202 || this.responseStatusCode == 404) {
            this.httpExchange.sendResponseHeaders(this.responseStatusCode, -1L);
        }
        this.httpExchange.close();
    }

    @Override
    public boolean hasFault() throws IOException {
        return this.responseStatusCode == 500;
    }

    @Override
    @Deprecated
    public void setFault(boolean fault) throws IOException {
        this.responseStatusCode = fault ? 500 : 200;
    }

    @Override
    public void setFaultCode(QName faultCode) throws IOException {
        this.responseStatusCode = faultCode != null ? (SOAPConstants.SOAP_SENDER_FAULT.equals(faultCode) ? 400 : 500) : 200;
    }
}

