/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.ws.transport.http.LastModifiedHelper;
import org.springframework.ws.transport.http.LocationTransformerObjectSupport;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;

public class XsdSchemaHandlerAdapter
extends LocationTransformerObjectSupport
implements HandlerAdapter,
InitializingBean {
    public static final String DEFAULT_SCHEMA_LOCATION_EXPRESSION = "//@schemaLocation";
    private static final String CONTENT_TYPE = "text/xml";
    private Map<String, String> expressionNamespaces = new HashMap<String, String>();
    private String schemaLocationExpression = "//@schemaLocation";
    private XPathExpression schemaLocationXPathExpression;
    private boolean transformSchemaLocations = false;

    public void setSchemaLocationExpression(String schemaLocationExpression) {
        this.schemaLocationExpression = schemaLocationExpression;
    }

    public void setTransformSchemaLocations(boolean transformSchemaLocations) {
        this.transformSchemaLocations = transformSchemaLocations;
    }

    @Override
    public long getLastModified(HttpServletRequest request, Object handler) {
        Source schemaSource = ((XsdSchema)handler).getSource();
        return LastModifiedHelper.getLastModified(schemaSource);
    }

    @Override
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if ("GET".equals(request.getMethod())) {
            Transformer transformer = this.createTransformer();
            Source schemaSource = this.getSchemaSource((XsdSchema)handler);
            if (this.transformSchemaLocations) {
                DOMResult domResult = new DOMResult();
                transformer.transform(schemaSource, domResult);
                Document schemaDocument = (Document)domResult.getNode();
                this.transformSchemaLocations(schemaDocument, request);
                schemaSource = new DOMSource(schemaDocument);
            }
            response.setContentType(CONTENT_TYPE);
            StreamResult responseResult = new StreamResult((OutputStream)response.getOutputStream());
            transformer.transform(schemaSource, responseResult);
        } else {
            response.setStatus(405);
        }
        return null;
    }

    @Override
    public boolean supports(Object handler) {
        return handler instanceof XsdSchema;
    }

    public void afterPropertiesSet() throws Exception {
        this.schemaLocationXPathExpression = XPathExpressionFactory.createXPathExpression(this.schemaLocationExpression, this.expressionNamespaces);
    }

    protected Source getSchemaSource(XsdSchema schema) throws Exception {
        return schema.getSource();
    }

    protected void transformSchemaLocations(Document definitionDocument, HttpServletRequest request) throws Exception {
        this.transformLocations(this.schemaLocationXPathExpression, definitionDocument, request);
    }
}

