/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail;

import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.mail.MailSenderConnection;
import org.springframework.ws.transport.mail.support.MailTransportUtils;

public class MailMessageSender
implements WebServiceMessageSender,
InitializingBean {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 60000L;
    private long receiveSleepTime = 60000L;
    private Session session = Session.getInstance((Properties)new Properties(), null);
    private URLName storeUri;
    private URLName transportUri;
    private InternetAddress from;

    public void setFrom(String from) throws AddressException {
        this.from = new InternetAddress(from);
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.session = Session.getInstance((Properties)javaMailProperties, null);
    }

    public void setReceiveSleepTime(long receiveSleepTime) {
        this.receiveSleepTime = receiveSleepTime;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setStoreUri(String storeUri) {
        this.storeUri = new URLName(storeUri);
    }

    public void setTransportUri(String transportUri) {
        this.transportUri = new URLName(transportUri);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.transportUri, (String)"'transportUri' is required");
        Assert.notNull((Object)this.storeUri, (String)"'storeUri' is required");
    }

    @Override
    public WebServiceConnection createConnection(URI uri) throws IOException {
        String subject;
        InternetAddress to = MailTransportUtils.getTo(uri);
        MailSenderConnection connection = new MailSenderConnection(this.session, this.transportUri, this.storeUri, to, this.receiveSleepTime);
        if (this.from != null) {
            connection.setFrom(this.from);
        }
        if ((subject = MailTransportUtils.getSubject(uri)) != null) {
            connection.setSubject(subject);
        }
        return connection;
    }

    @Override
    public boolean supports(URI uri) {
        return uri.getScheme().equals("mailto");
    }
}

