/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpLogging;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.util.Assert;

public class StompEncoder {
    private static final byte LF = 10;
    private static final byte COLON = 58;
    private static final Log logger = SimpLogging.forLogName(StompEncoder.class);
    private static final int HEADER_KEY_CACHE_LIMIT = 32;
    private final Map<String, byte[]> headerKeyAccessCache = new ConcurrentHashMap<String, byte[]>(32);
    private final Map<String, byte[]> headerKeyUpdateCache = new LinkedHashMap<String, byte[]>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, byte[]> eldest) {
            if (this.size() > 32) {
                StompEncoder.this.headerKeyAccessCache.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    };

    public byte[] encode(Message<byte[]> message) {
        return this.encode(message.getHeaders(), message.getPayload());
    }

    public byte[] encode(Map<String, Object> headers, byte[] payload) {
        Assert.notNull(headers, (String)"'headers' is required");
        Assert.notNull((Object)payload, (String)"'payload' is required");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128 + payload.length);
            DataOutputStream output = new DataOutputStream(baos);
            if (SimpMessageType.HEARTBEAT.equals((Object)SimpMessageHeaderAccessor.getMessageType(headers))) {
                logger.trace("Encoding heartbeat");
                output.write(StompDecoder.HEARTBEAT_PAYLOAD);
            } else {
                StompCommand command = StompHeaderAccessor.getCommand(headers);
                if (command == null) {
                    throw new IllegalStateException("Missing STOMP command: " + headers);
                }
                output.write(command.toString().getBytes(StandardCharsets.UTF_8));
                output.write(10);
                this.writeHeaders(command, headers, payload, output);
                output.write(10);
                this.writeBody(payload, output);
                output.write(0);
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new StompConversionException("Failed to encode STOMP frame, headers=" + headers, ex);
        }
    }

    private void writeHeaders(StompCommand command, Map<String, Object> headers, byte[] payload, DataOutputStream output) throws IOException {
        Map nativeHeaders = (Map)headers.get("nativeHeaders");
        if (logger.isTraceEnabled()) {
            logger.trace("Encoding STOMP " + (Object)((Object)command) + ", headers=" + nativeHeaders);
        }
        if (nativeHeaders == null) {
            return;
        }
        boolean shouldEscape = command != StompCommand.CONNECT && command != StompCommand.STOMP && command != StompCommand.CONNECTED;
        for (Map.Entry entry : nativeHeaders.entrySet()) {
            if (command.requiresContentLength() && "content-length".equals(entry.getKey())) continue;
            List<String> values = (List<String>)entry.getValue();
            if ((StompCommand.CONNECT.equals((Object)command) || StompCommand.STOMP.equals((Object)command)) && "passcode".equals(entry.getKey())) {
                values = Collections.singletonList(StompHeaderAccessor.getPasscode(headers));
            }
            byte[] encodedKey = this.encodeHeaderKey((String)entry.getKey(), shouldEscape);
            for (String value : values) {
                output.write(encodedKey);
                output.write(58);
                output.write(this.encodeHeaderValue(value, shouldEscape));
                output.write(10);
            }
        }
        if (command.requiresContentLength()) {
            int contentLength = payload.length;
            output.write("content-length:".getBytes(StandardCharsets.UTF_8));
            output.write(Integer.toString(contentLength).getBytes(StandardCharsets.UTF_8));
            output.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encodeHeaderKey(String input, boolean escape) {
        String inputToUse;
        String string = inputToUse = escape ? this.escape(input) : input;
        if (this.headerKeyAccessCache.containsKey(inputToUse)) {
            return this.headerKeyAccessCache.get(inputToUse);
        }
        Map<String, byte[]> map = this.headerKeyUpdateCache;
        synchronized (map) {
            byte[] bytes = this.headerKeyUpdateCache.get(inputToUse);
            if (bytes == null) {
                bytes = inputToUse.getBytes(StandardCharsets.UTF_8);
                this.headerKeyAccessCache.put(inputToUse, bytes);
                this.headerKeyUpdateCache.put(inputToUse, bytes);
            }
            return bytes;
        }
    }

    private byte[] encodeHeaderValue(String input, boolean escape) {
        String inputToUse = escape ? this.escape(input) : input;
        return inputToUse.getBytes(StandardCharsets.UTF_8);
    }

    private String escape(String inString) {
        StringBuilder sb = null;
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (c == '\\') {
                sb = this.getStringBuilder(sb, inString, i);
                sb.append("\\\\");
                continue;
            }
            if (c == ':') {
                sb = this.getStringBuilder(sb, inString, i);
                sb.append("\\c");
                continue;
            }
            if (c == '\n') {
                sb = this.getStringBuilder(sb, inString, i);
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb = this.getStringBuilder(sb, inString, i);
                sb.append("\\r");
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : inString;
    }

    private StringBuilder getStringBuilder(@Nullable StringBuilder sb, String inString, int i) {
        if (sb == null) {
            sb = new StringBuilder(inString.length());
            sb.append(inString.substring(0, i));
        }
        return sb;
    }

    private void writeBody(byte[] payload, DataOutputStream output) throws IOException {
        output.write(payload);
    }
}

