/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.client.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.WebServiceIOException;
import org.springframework.ws.client.WebServiceTransformerException;
import org.springframework.ws.client.WebServiceTransportException;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceOperations;
import org.springframework.ws.client.support.WebServiceAccessor;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.support.DefaultStrategiesHelper;
import org.springframework.ws.support.MarshallingUtils;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;
import org.springframework.ws.transport.TransportException;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.context.DefaultTransportContext;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.support.TransportUtils;

public class WebServiceTemplate
extends WebServiceAccessor
implements WebServiceOperations {
    public static final String MESSAGE_TRACING_LOG_CATEGORY = "org.springframework.ws.client.MessageTracing";
    protected static final Log sentMessageTracingLogger = LogFactory.getLog("org.springframework.ws.client.MessageTracing.sent");
    protected static final Log receivedMessageTracingLogger = LogFactory.getLog("org.springframework.ws.client.MessageTracing.received");
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private FaultMessageResolver faultMessageResolver;
    private boolean checkConnectionForError = true;
    private boolean checkConnectionForFault = true;
    private ClientInterceptor[] interceptors;
    private DestinationProvider destinationProvider;

    public WebServiceTemplate() {
        this.initDefaultStrategies();
    }

    public WebServiceTemplate(WebServiceMessageFactory messageFactory) {
        this.setMessageFactory(messageFactory);
        this.initDefaultStrategies();
    }

    public WebServiceTemplate(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        if (!(marshaller instanceof Unmarshaller)) {
            throw new IllegalArgumentException("Marshaller [" + marshaller + "] does not implement the Unmarshaller interface. Please set an Unmarshaller explicitly by using the WebServiceTemplate(Marshaller, Unmarshaller) constructor.");
        }
        this.setMarshaller(marshaller);
        this.setUnmarshaller((Unmarshaller)((Object)marshaller));
        this.initDefaultStrategies();
    }

    public WebServiceTemplate(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.setMarshaller(marshaller);
        this.setUnmarshaller(unmarshaller);
        this.initDefaultStrategies();
    }

    public String getDefaultUri() {
        if (this.destinationProvider != null) {
            URI uri = this.destinationProvider.getDestination();
            return uri != null ? uri.toString() : null;
        }
        return null;
    }

    public void setDefaultUri(final String uri) {
        this.destinationProvider = new DestinationProvider(){

            @Override
            public URI getDestination() {
                return URI.create(uri);
            }
        };
    }

    public DestinationProvider getDestinationProvider() {
        return this.destinationProvider;
    }

    public void setDestinationProvider(DestinationProvider destinationProvider) {
        this.destinationProvider = destinationProvider;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public FaultMessageResolver getFaultMessageResolver() {
        return this.faultMessageResolver;
    }

    public void setFaultMessageResolver(FaultMessageResolver faultMessageResolver) {
        this.faultMessageResolver = faultMessageResolver;
    }

    public void setCheckConnectionForError(boolean checkConnectionForError) {
        this.checkConnectionForError = checkConnectionForError;
    }

    public void setCheckConnectionForFault(boolean checkConnectionForFault) {
        this.checkConnectionForFault = checkConnectionForFault;
    }

    public ClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public final void setInterceptors(ClientInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    protected void initDefaultStrategies() {
        DefaultStrategiesHelper strategiesHelper = new DefaultStrategiesHelper(WebServiceTemplate.class);
        if (this.getMessageFactory() == null) {
            this.initMessageFactory(strategiesHelper);
        }
        if (ObjectUtils.isEmpty((Object[])this.getMessageSenders())) {
            this.initMessageSenders(strategiesHelper);
        }
        if (this.getFaultMessageResolver() == null) {
            this.initFaultMessageResolver(strategiesHelper);
        }
    }

    private void initMessageFactory(DefaultStrategiesHelper helper) throws BeanInitializationException {
        WebServiceMessageFactory messageFactory = helper.getDefaultStrategy(WebServiceMessageFactory.class);
        this.setMessageFactory(messageFactory);
    }

    private void initMessageSenders(DefaultStrategiesHelper helper) {
        List<WebServiceMessageSender> messageSenders = helper.getDefaultStrategies(WebServiceMessageSender.class);
        this.setMessageSenders(messageSenders.toArray(new WebServiceMessageSender[messageSenders.size()]));
    }

    private void initFaultMessageResolver(DefaultStrategiesHelper helper) throws BeanInitializationException {
        FaultMessageResolver faultMessageResolver = helper.getDefaultStrategy(FaultMessageResolver.class);
        this.setFaultMessageResolver(faultMessageResolver);
    }

    @Override
    public Object marshalSendAndReceive(Object requestPayload) {
        return this.marshalSendAndReceive(requestPayload, null);
    }

    @Override
    public Object marshalSendAndReceive(String uri, Object requestPayload) {
        return this.marshalSendAndReceive(uri, requestPayload, null);
    }

    @Override
    public Object marshalSendAndReceive(Object requestPayload, WebServiceMessageCallback requestCallback) {
        return this.marshalSendAndReceive(this.getDefaultUri(), requestPayload, requestCallback);
    }

    @Override
    public Object marshalSendAndReceive(String uri, final Object requestPayload, final WebServiceMessageCallback requestCallback) {
        return this.sendAndReceive(uri, new WebServiceMessageCallback(){

            @Override
            public void doWithMessage(WebServiceMessage request) throws IOException, TransformerException {
                if (requestPayload != null) {
                    Marshaller marshaller = WebServiceTemplate.this.getMarshaller();
                    if (marshaller == null) {
                        throw new IllegalStateException("No marshaller registered. Check configuration of WebServiceTemplate.");
                    }
                    MarshallingUtils.marshal(marshaller, requestPayload, request);
                    if (requestCallback != null) {
                        requestCallback.doWithMessage(request);
                    }
                }
            }
        }, new WebServiceMessageExtractor<Object>(){

            @Override
            public Object extractData(WebServiceMessage response) throws IOException {
                Unmarshaller unmarshaller = WebServiceTemplate.this.getUnmarshaller();
                if (unmarshaller == null) {
                    throw new IllegalStateException("No unmarshaller registered. Check configuration of WebServiceTemplate.");
                }
                return MarshallingUtils.unmarshal(unmarshaller, response);
            }
        });
    }

    @Override
    public boolean sendSourceAndReceiveToResult(Source requestPayload, Result responseResult) {
        return this.sendSourceAndReceiveToResult(requestPayload, null, responseResult);
    }

    @Override
    public boolean sendSourceAndReceiveToResult(String uri, Source requestPayload, Result responseResult) {
        return this.sendSourceAndReceiveToResult(uri, requestPayload, null, responseResult);
    }

    @Override
    public boolean sendSourceAndReceiveToResult(Source requestPayload, WebServiceMessageCallback requestCallback, Result responseResult) {
        return this.sendSourceAndReceiveToResult(this.getDefaultUri(), requestPayload, requestCallback, responseResult);
    }

    @Override
    public boolean sendSourceAndReceiveToResult(String uri, Source requestPayload, WebServiceMessageCallback requestCallback, final Result responseResult) {
        try {
            final Transformer transformer = this.createTransformer();
            Boolean retVal = this.doSendAndReceive(uri, transformer, requestPayload, requestCallback, new SourceExtractor<Boolean>(){

                @Override
                public Boolean extractData(Source source) throws IOException, TransformerException {
                    if (source != null) {
                        transformer.transform(source, responseResult);
                    }
                    return Boolean.TRUE;
                }
            });
            return retVal != null && retVal != false;
        }
        catch (TransformerConfigurationException ex) {
            throw new WebServiceTransformerException("Could not create transformer", ex);
        }
    }

    @Override
    public <T> T sendSourceAndReceive(Source requestPayload, SourceExtractor<T> responseExtractor) {
        return this.sendSourceAndReceive(requestPayload, null, responseExtractor);
    }

    @Override
    public <T> T sendSourceAndReceive(String uri, Source requestPayload, SourceExtractor<T> responseExtractor) {
        return this.sendSourceAndReceive(uri, requestPayload, null, responseExtractor);
    }

    @Override
    public <T> T sendSourceAndReceive(Source requestPayload, WebServiceMessageCallback requestCallback, SourceExtractor<T> responseExtractor) {
        return this.sendSourceAndReceive(this.getDefaultUri(), requestPayload, requestCallback, responseExtractor);
    }

    @Override
    public <T> T sendSourceAndReceive(String uri, Source requestPayload, WebServiceMessageCallback requestCallback, SourceExtractor<T> responseExtractor) {
        try {
            return this.doSendAndReceive(uri, this.createTransformer(), requestPayload, requestCallback, responseExtractor);
        }
        catch (TransformerConfigurationException ex) {
            throw new WebServiceTransformerException("Could not create transformer", ex);
        }
    }

    private <T> T doSendAndReceive(String uri, final Transformer transformer, final Source requestPayload, final WebServiceMessageCallback requestCallback, SourceExtractor<T> responseExtractor) {
        Assert.notNull(responseExtractor, (String)"responseExtractor must not be null");
        return this.sendAndReceive(uri, new WebServiceMessageCallback(){

            @Override
            public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
                transformer.transform(requestPayload, message.getPayloadResult());
                if (requestCallback != null) {
                    requestCallback.doWithMessage(message);
                }
            }
        }, new SourceExtractorMessageExtractor(responseExtractor));
    }

    @Override
    public boolean sendAndReceive(WebServiceMessageCallback requestCallback, WebServiceMessageCallback responseCallback) {
        return this.sendAndReceive(this.getDefaultUri(), requestCallback, responseCallback);
    }

    @Override
    public boolean sendAndReceive(String uri, WebServiceMessageCallback requestCallback, WebServiceMessageCallback responseCallback) {
        Assert.notNull((Object)responseCallback, (String)"responseCallback must not be null");
        Boolean result = this.sendAndReceive(uri, requestCallback, new WebServiceMessageCallbackMessageExtractor(responseCallback));
        return result != null && result != false;
    }

    @Override
    public <T> T sendAndReceive(WebServiceMessageCallback requestCallback, WebServiceMessageExtractor<T> responseExtractor) {
        return this.sendAndReceive(this.getDefaultUri(), requestCallback, responseExtractor);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T sendAndReceive(String uriString, WebServiceMessageCallback requestCallback, WebServiceMessageExtractor<T> responseExtractor) {
        T t;
        Assert.notNull(responseExtractor, (String)"'responseExtractor' must not be null");
        Assert.hasLength((String)uriString, (String)"'uri' must not be empty");
        TransportContext previousTransportContext = TransportContextHolder.getTransportContext();
        WebServiceConnection connection = null;
        try {
            connection = this.createConnection(URI.create(uriString));
            TransportContextHolder.setTransportContext(new DefaultTransportContext(connection));
            DefaultMessageContext messageContext = new DefaultMessageContext(this.getMessageFactory());
            t = this.doSendAndReceive(messageContext, connection, requestCallback, responseExtractor);
        }
        catch (TransportException ex) {
            try {
                throw new WebServiceTransportException("Could not use transport: " + ex.getMessage(), ex);
                catch (IOException ex2) {
                    throw new WebServiceIOException("I/O error: " + ex2.getMessage(), ex2);
                }
            }
            catch (Throwable throwable) {
                TransportUtils.closeConnection(connection);
                TransportContextHolder.setTransportContext(previousTransportContext);
                throw throwable;
            }
        }
        TransportUtils.closeConnection(connection);
        TransportContextHolder.setTransportContext(previousTransportContext);
        return t;
    }

    protected <T> T doSendAndReceive(MessageContext messageContext, WebServiceConnection connection, WebServiceMessageCallback requestCallback, WebServiceMessageExtractor<T> responseExtractor) throws IOException {
        int interceptorIndex = -1;
        try {
            if (requestCallback != null) {
                requestCallback.doWithMessage(messageContext.getRequest());
            }
            boolean intercepted = false;
            if (this.interceptors != null) {
                for (int i = 0; i < this.interceptors.length; ++i) {
                    interceptorIndex = i;
                    if (this.interceptors[i].handleRequest(messageContext)) continue;
                    intercepted = true;
                    break;
                }
            }
            if (!messageContext.hasResponse() && !intercepted) {
                this.sendRequest(connection, messageContext.getRequest());
                if (this.hasError(connection, messageContext.getRequest())) {
                    this.triggerAfterCompletion(interceptorIndex, messageContext, null);
                    return (T)this.handleError(connection, messageContext.getRequest());
                }
                WebServiceMessage response = connection.receive(this.getMessageFactory());
                messageContext.setResponse(response);
            }
            this.logResponse(messageContext);
            if (messageContext.hasResponse()) {
                if (!this.hasFault(connection, messageContext.getResponse())) {
                    this.triggerHandleResponse(interceptorIndex, messageContext);
                    this.triggerAfterCompletion(interceptorIndex, messageContext, null);
                    return responseExtractor.extractData(messageContext.getResponse());
                }
                this.triggerHandleFault(interceptorIndex, messageContext);
                this.triggerAfterCompletion(interceptorIndex, messageContext, null);
                return (T)this.handleFault(connection, messageContext);
            }
            this.triggerAfterCompletion(interceptorIndex, messageContext, null);
            return null;
        }
        catch (TransformerException ex) {
            this.triggerAfterCompletion(interceptorIndex, messageContext, ex);
            throw new WebServiceTransformerException("Transformation error: " + ex.getMessage(), ex);
        }
        catch (RuntimeException ex) {
            this.triggerAfterCompletion(interceptorIndex, messageContext, ex);
            throw ex;
        }
        catch (IOException ex) {
            this.triggerAfterCompletion(interceptorIndex, messageContext, ex);
            throw ex;
        }
    }

    private void sendRequest(WebServiceConnection connection, WebServiceMessage request) throws IOException {
        if (sentMessageTracingLogger.isTraceEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            request.writeTo(os);
            sentMessageTracingLogger.trace("Sent request [" + os.toString("UTF-8") + "]");
        } else if (sentMessageTracingLogger.isDebugEnabled()) {
            sentMessageTracingLogger.debug("Sent request [" + request + "]");
        }
        connection.send(request);
    }

    protected boolean hasError(WebServiceConnection connection, WebServiceMessage request) throws IOException {
        if (this.checkConnectionForError && connection.hasError()) {
            if (this.checkConnectionForFault && connection instanceof FaultAwareWebServiceConnection) {
                FaultAwareWebServiceConnection faultConnection = (FaultAwareWebServiceConnection)connection;
                return !faultConnection.hasFault() || !(request instanceof FaultAwareWebServiceMessage);
            }
            return true;
        }
        return false;
    }

    protected Object handleError(WebServiceConnection connection, WebServiceMessage request) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received error for request [" + request + "]");
        }
        throw new WebServiceTransportException(connection.getErrorMessage());
    }

    private void logResponse(MessageContext messageContext) throws IOException {
        if (messageContext.hasResponse()) {
            if (receivedMessageTracingLogger.isTraceEnabled()) {
                ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
                messageContext.getRequest().writeTo(requestStream);
                ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
                messageContext.getResponse().writeTo(responseStream);
                receivedMessageTracingLogger.trace("Received response [" + responseStream.toString("UTF-8") + "] for request [" + requestStream.toString("UTF-8") + "]");
            } else if (receivedMessageTracingLogger.isDebugEnabled()) {
                receivedMessageTracingLogger.debug("Received response [" + messageContext.getResponse() + "] for request [" + messageContext.getRequest() + "]");
            }
        } else if (receivedMessageTracingLogger.isDebugEnabled()) {
            receivedMessageTracingLogger.debug("Received no response for request [" + messageContext.getRequest() + "]");
        }
    }

    protected boolean hasFault(WebServiceConnection connection, WebServiceMessage response) throws IOException {
        FaultAwareWebServiceConnection faultConnection;
        if (this.checkConnectionForFault && connection instanceof FaultAwareWebServiceConnection && !(faultConnection = (FaultAwareWebServiceConnection)connection).hasFault()) {
            return false;
        }
        if (response instanceof FaultAwareWebServiceMessage) {
            FaultAwareWebServiceMessage faultMessage = (FaultAwareWebServiceMessage)response;
            return faultMessage.hasFault();
        }
        return false;
    }

    private void triggerHandleResponse(int interceptorIndex, MessageContext messageContext) {
        if (messageContext.hasResponse() && this.interceptors != null) {
            for (int i = interceptorIndex; i >= 0 && this.interceptors[i].handleResponse(messageContext); --i) {
            }
        }
    }

    private void triggerHandleFault(int interceptorIndex, MessageContext messageContext) {
        if (messageContext.hasResponse() && this.interceptors != null) {
            for (int i = interceptorIndex; i >= 0 && this.interceptors[i].handleFault(messageContext); --i) {
            }
        }
    }

    private void triggerAfterCompletion(int interceptorIndex, MessageContext messageContext, Exception ex) throws WebServiceClientException {
        if (this.interceptors != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                this.interceptors[i].afterCompletion(messageContext, ex);
            }
        }
    }

    protected Object handleFault(WebServiceConnection connection, MessageContext messageContext) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received Fault message for request [" + messageContext.getRequest() + "]");
        }
        if (this.getFaultMessageResolver() != null) {
            this.getFaultMessageResolver().resolveFault(messageContext.getResponse());
            return null;
        }
        return this.handleError(connection, messageContext.getRequest());
    }

    private static class SourceExtractorMessageExtractor<T>
    implements WebServiceMessageExtractor<T> {
        private final SourceExtractor<T> sourceExtractor;

        private SourceExtractorMessageExtractor(SourceExtractor<T> sourceExtractor) {
            this.sourceExtractor = sourceExtractor;
        }

        @Override
        public T extractData(WebServiceMessage message) throws IOException, TransformerException {
            return this.sourceExtractor.extractData(message.getPayloadSource());
        }
    }

    private static class WebServiceMessageCallbackMessageExtractor
    implements WebServiceMessageExtractor<Boolean> {
        private final WebServiceMessageCallback callback;

        private WebServiceMessageCallbackMessageExtractor(WebServiceMessageCallback callback) {
            this.callback = callback;
        }

        @Override
        public Boolean extractData(WebServiceMessage message) throws IOException, TransformerException {
            this.callback.doWithMessage(message);
            return Boolean.TRUE;
        }
    }
}

