/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.support.MarshallingUtils;

@Deprecated
public abstract class AbstractMarshallingPayloadEndpoint
implements MessageEndpoint,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    protected AbstractMarshallingPayloadEndpoint() {
    }

    protected AbstractMarshallingPayloadEndpoint(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        if (!(marshaller instanceof Unmarshaller)) {
            throw new IllegalArgumentException("Marshaller [" + marshaller + "] does not implement the Unmarshaller interface. Please set an Unmarshaller explicitly by using the AbstractMarshallingPayloadEndpoint(Marshaller, Unmarshaller) constructor.");
        }
        this.setMarshaller(marshaller);
        this.setUnmarshaller((Unmarshaller)((Object)marshaller));
    }

    protected AbstractMarshallingPayloadEndpoint(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.setMarshaller(marshaller);
        this.setUnmarshaller(unmarshaller);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public final void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public final void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void afterPropertiesSet() throws Exception {
        this.afterMarshallerSet();
    }

    @Override
    public final void invoke(MessageContext messageContext) throws Exception {
        Object responseObject;
        WebServiceMessage request = messageContext.getRequest();
        Object requestObject = this.unmarshalRequest(request);
        if (this.onUnmarshalRequest(messageContext, requestObject) && (responseObject = this.invokeInternal(requestObject)) != null) {
            WebServiceMessage response = messageContext.getResponse();
            this.marshalResponse(responseObject, response);
            this.onMarshalResponse(messageContext, requestObject, responseObject);
        }
    }

    private Object unmarshalRequest(WebServiceMessage request) throws IOException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        Assert.notNull((Object)unmarshaller, (String)"No unmarshaller registered. Check configuration of endpoint.");
        Object requestObject = MarshallingUtils.unmarshal(unmarshaller, request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unmarshalled payload request to [" + requestObject + "]");
        }
        return requestObject;
    }

    protected boolean onUnmarshalRequest(MessageContext messageContext, Object requestObject) throws Exception {
        return true;
    }

    private void marshalResponse(Object responseObject, WebServiceMessage response) throws IOException {
        Marshaller marshaller = this.getMarshaller();
        Assert.notNull((Object)marshaller, (String)"No marshaller registered. Check configuration of endpoint.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Marshalling [" + responseObject + "] to response payload");
        }
        MarshallingUtils.marshal(marshaller, responseObject, response);
    }

    protected void onMarshalResponse(MessageContext messageContext, Object requestObject, Object responseObject) {
    }

    @Deprecated
    public void afterMarshallerSet() throws Exception {
    }

    protected abstract Object invokeInternal(Object var1) throws Exception;
}

