/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.annotation.Annotation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.mapping.AbstractMethodEndpointMapping;

public abstract class AbstractAnnotationMethodEndpointMapping<T>
extends AbstractMethodEndpointMapping<T> {
    private boolean detectEndpointsInAncestorContexts = false;

    public void setDetectEndpointsInAncestorContexts(boolean detectEndpointsInAncestorContexts) {
        this.detectEndpointsInAncestorContexts = detectEndpointsInAncestorContexts;
    }

    protected Class<? extends Annotation> getEndpointAnnotationType() {
        return Endpoint.class;
    }

    @Override
    protected void initApplicationContext() throws BeansException {
        String[] beanNames;
        super.initApplicationContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking for endpoints in application context: " + this.getApplicationContext());
        }
        for (String beanName : beanNames = this.detectEndpointsInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), Object.class) : this.getApplicationContext().getBeanNamesForType(Object.class)) {
            Class endpointClass = this.getApplicationContext().getType(beanName);
            if (endpointClass == null || AnnotationUtils.findAnnotation((Class)endpointClass, this.getEndpointAnnotationType()) == null) continue;
            this.registerMethods(beanName);
        }
    }
}

