/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.InvalidXmlException;
import org.springframework.ws.soap.SoapMessageCreationException;
import org.springframework.ws.soap.SoapMessageFactory;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.soap.saaj.support.SaajUtils;
import org.springframework.ws.transport.TransportInputStream;
import org.xml.sax.SAXParseException;

public class SaajSoapMessageFactory
implements SoapMessageFactory,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SaajSoapMessageFactory.class);
    private MessageFactory messageFactory;
    private String messageFactoryProtocol;
    private boolean langAttributeOnSoap11FaultString = true;
    private Map<String, ?> messageProperties;

    public SaajSoapMessageFactory() {
    }

    public SaajSoapMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setMessageProperties(Map<String, ?> messageProperties) {
        this.messageProperties = messageProperties;
    }

    public void setLangAttributeOnSoap11FaultString(boolean langAttributeOnSoap11FaultString) {
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSoapVersion(SoapVersion version) {
        if (SaajUtils.getSaajVersion() >= 2) {
            if (SoapVersion.SOAP_11 == version) {
                this.messageFactoryProtocol = "SOAP 1.1 Protocol";
                return;
            } else {
                if (SoapVersion.SOAP_12 != version) throw new IllegalArgumentException("Invalid version [" + version + "]. Expected the SOAP_11 or SOAP_12 constant");
                this.messageFactoryProtocol = "SOAP 1.2 Protocol";
            }
            return;
        } else {
            if (SoapVersion.SOAP_11 == version) return;
            throw new IllegalArgumentException("SAAJ 1.1 and 1.2 only support SOAP 1.1");
        }
    }

    public void afterPropertiesSet() {
        block10: {
            if (this.messageFactory == null) {
                try {
                    if (SaajUtils.getSaajVersion() >= 2) {
                        if (!StringUtils.hasLength((String)this.messageFactoryProtocol)) {
                            this.messageFactoryProtocol = "SOAP 1.1 Protocol";
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("Creating SAAJ 1.3 MessageFactory with " + this.messageFactoryProtocol);
                        }
                        this.messageFactory = MessageFactory.newInstance((String)this.messageFactoryProtocol);
                        break block10;
                    }
                    if (SaajUtils.getSaajVersion() == 1) {
                        logger.info("Creating SAAJ 1.2 MessageFactory");
                        this.messageFactory = MessageFactory.newInstance();
                        break block10;
                    }
                    if (SaajUtils.getSaajVersion() == 0) {
                        logger.info("Creating SAAJ 1.1 MessageFactory");
                        this.messageFactory = MessageFactory.newInstance();
                        break block10;
                    }
                    throw new IllegalStateException("SaajSoapMessageFactory requires SAAJ 1.1, which was not found on the classpath");
                }
                catch (NoSuchMethodError ex) {
                    throw new SoapMessageCreationException("Could not create SAAJ MessageFactory. Is the version of the SAAJ specification interfaces [" + SaajUtils.getSaajVersionString() + "] the same as the version supported by the application server?", ex);
                }
                catch (SOAPException ex) {
                    throw new SoapMessageCreationException("Could not create SAAJ MessageFactory: " + ex.getMessage(), ex);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using MessageFactory class [" + this.messageFactory.getClass().getName() + "]");
        }
    }

    @Override
    public SaajSoapMessage createWebServiceMessage() {
        try {
            SOAPMessage saajMessage = this.messageFactory.createMessage();
            this.postProcess(saajMessage);
            return new SaajSoapMessage(saajMessage, this.langAttributeOnSoap11FaultString, this.messageFactory);
        }
        catch (SOAPException ex) {
            throw new SoapMessageCreationException("Could not create empty message: " + ex.getMessage(), ex);
        }
    }

    @Override
    public SaajSoapMessage createWebServiceMessage(InputStream inputStream) throws IOException {
        MimeHeaders mimeHeaders = this.parseMimeHeaders(inputStream);
        try {
            inputStream = this.checkForUtf8ByteOrderMark(inputStream);
            SOAPMessage saajMessage = this.messageFactory.createMessage(mimeHeaders, inputStream);
            saajMessage.getSOAPPart().getEnvelope();
            this.postProcess(saajMessage);
            return new SaajSoapMessage(saajMessage, this.langAttributeOnSoap11FaultString, this.messageFactory);
        }
        catch (SOAPException ex) {
            SAXParseException parseException;
            String contentType = StringUtils.arrayToCommaDelimitedString((Object[])mimeHeaders.getHeader("Content-Type"));
            if (contentType.contains("startinfo")) {
                contentType = contentType.replace("startinfo", "start-info");
                mimeHeaders.setHeader("Content-Type", contentType);
                try {
                    SOAPMessage saajMessage = this.messageFactory.createMessage(mimeHeaders, inputStream);
                    this.postProcess(saajMessage);
                    return new SaajSoapMessage(saajMessage, this.langAttributeOnSoap11FaultString);
                }
                catch (SOAPException saajMessage) {
                    // empty catch block
                }
            }
            if ((parseException = this.getSAXParseException(ex)) != null) {
                throw new InvalidXmlException("Could not parse XML", parseException);
            }
            throw new SoapMessageCreationException("Could not create message from InputStream: " + ex.getMessage(), ex);
        }
    }

    private SAXParseException getSAXParseException(Throwable ex) {
        if (ex instanceof SAXParseException) {
            return (SAXParseException)ex;
        }
        if (ex.getCause() != null) {
            return this.getSAXParseException(ex.getCause());
        }
        return null;
    }

    private MimeHeaders parseMimeHeaders(InputStream inputStream) throws IOException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        if (inputStream instanceof TransportInputStream) {
            TransportInputStream transportInputStream = (TransportInputStream)inputStream;
            Iterator<String> headerNames = transportInputStream.getHeaderNames();
            while (headerNames.hasNext()) {
                String headerName = headerNames.next();
                Iterator<String> headerValues = transportInputStream.getHeaders(headerName);
                while (headerValues.hasNext()) {
                    String headerValue = headerValues.next();
                    StringTokenizer tokenizer = new StringTokenizer(headerValue, ",");
                    while (tokenizer.hasMoreTokens()) {
                        mimeHeaders.addHeader(headerName, tokenizer.nextToken().trim());
                    }
                }
            }
        }
        return mimeHeaders;
    }

    private InputStream checkForUtf8ByteOrderMark(InputStream inputStream) throws IOException {
        int bytesRead;
        int n;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bytes = new byte[3];
        for (bytesRead = 0; bytesRead < bytes.length && (n = pushbackInputStream.read(bytes, bytesRead, bytes.length - bytesRead)) > 0; bytesRead += n) {
        }
        if (bytesRead > 0 && !this.isByteOrderMark(bytes)) {
            pushbackInputStream.unread(bytes, 0, bytesRead);
        }
        return pushbackInputStream;
    }

    private boolean isByteOrderMark(byte[] bytes) {
        return bytes.length == 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
    }

    protected void postProcess(SOAPMessage soapMessage) throws SOAPException {
        MimeHeaders headers;
        if (!CollectionUtils.isEmpty(this.messageProperties)) {
            for (Map.Entry<String, ?> entry : this.messageProperties.entrySet()) {
                soapMessage.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if ("SOAP 1.1 Protocol".equals(this.messageFactoryProtocol) && ObjectUtils.isEmpty((Object[])(headers = soapMessage.getMimeHeaders()).getHeader("SOAPAction"))) {
            headers.addHeader("SOAPAction", "\"\"");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SaajSoapMessageFactory[");
        builder.append(SaajUtils.getSaajVersionString());
        if (SaajUtils.getSaajVersion() >= 2) {
            builder.append(',');
            builder.append(this.messageFactoryProtocol);
        }
        builder.append(']');
        return builder.toString();
    }
}

