/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.Jid;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.xmpp.MessageInputStream;
import org.springframework.ws.transport.xmpp.MessageOutputStream;
import org.springframework.ws.transport.xmpp.support.XmppTransportUtils;

public class XmppReceiverConnection
extends AbstractReceiverConnection {
    private final XMPPConnection connection;
    private final Message requestMessage;
    private Message responseMessage;
    private String messageEncoding;

    public XmppReceiverConnection(XMPPConnection connection, Message requestMessage) {
        Assert.notNull((Object)connection, (String)"'connection' must not be null");
        Assert.notNull((Object)requestMessage, (String)"'requestMessage' must not be null");
        this.connection = connection;
        this.requestMessage = requestMessage;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setMessageEncoding(String messageEncoding) {
        this.messageEncoding = messageEncoding;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return XmppTransportUtils.toUri(this.requestMessage);
    }

    @Override
    public boolean hasError() {
        return XmppTransportUtils.hasError(this.responseMessage);
    }

    @Override
    public String getErrorMessage() {
        return XmppTransportUtils.getErrorMessage(this.responseMessage);
    }

    @Override
    public Iterator<String> getRequestHeaderNames() throws IOException {
        return XmppTransportUtils.getHeaderNames(this.requestMessage);
    }

    @Override
    public Iterator<String> getRequestHeaders(String name) throws IOException {
        return XmppTransportUtils.getHeaders(this.requestMessage, name);
    }

    @Override
    protected InputStream getRequestInputStream() throws IOException {
        return new MessageInputStream(this.requestMessage, this.messageEncoding);
    }

    @Override
    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        this.responseMessage = new Message(this.requestMessage.getFrom(), Message.Type.chat);
        this.responseMessage.setFrom((Jid)this.connection.getUser());
        this.responseMessage.setThread(this.requestMessage.getThread());
    }

    @Override
    public void addResponseHeader(String name, String value) throws IOException {
        XmppTransportUtils.addHeader(this.responseMessage, name, value);
    }

    @Override
    protected OutputStream getResponseOutputStream() throws IOException {
        return new MessageOutputStream(this.responseMessage, this.messageEncoding);
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        try {
            this.connection.sendStanza((Stanza)this.responseMessage);
        }
        catch (SmackException.NotConnectedException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

